/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto;

import java.util.Arrays;
import org.indunet.fastproto.ByteOrder;
import org.indunet.fastproto.exception.CodecException;

public enum BitOrder {
    LSB_0(1, "LSB_0"),
    MSB_0(2, "MSB_0");

    int code;
    String name;

    public static ByteOrder byName(String name) {
        return Arrays.stream(ByteOrder.values()).filter(p -> p.getName().equals(name)).findFirst().orElseThrow(() -> new CodecException("Invalid bit order, only LSB_0 or MSB_0 can be set."));
    }

    public int getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    private BitOrder(int code, String name) {
        this.code = code;
        this.name = name;
    }
}

