/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import java.util.Arrays;
import java.util.Collection;
import java.util.stream.IntStream;
import org.indunet.fastproto.BitOrder;
import org.indunet.fastproto.annotation.BoolArrayType;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CollectionUtils;

public class BoolArrayCodec
implements Codec<boolean[]> {
    @Override
    public boolean[] decode(CodecContext context, byte[] bytes) {
        try {
            BoolArrayType type = context.getDataTypeAnnotation(BoolArrayType.class);
            BitOrder bitOrder = Arrays.stream(type.bitOrder()).findFirst().orElseGet(context::getDefaultBitOrder);
            return this.decode(bytes, type.byteOffset(), type.bitOffset(), type.length(), bitOrder);
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new DecodingException("Fail decoding boolean array type.", (Throwable)e);
        }
    }

    @Override
    public void encode(CodecContext context, byte[] bytes, boolean[] values) {
        try {
            BoolArrayType type = context.getDataTypeAnnotation(BoolArrayType.class);
            BitOrder bitOrder = Arrays.stream(type.bitOrder()).findFirst().orElseGet(context::getDefaultBitOrder);
            this.encode(bytes, type.byteOffset(), type.bitOffset(), bitOrder, values);
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new EncodingException("Fail encoding boolean array type.", (Throwable)e);
        }
    }

    public boolean[] decode(byte[] bytes, int byteOffset, int bitOffset, int length, BitOrder bitOrder) {
        boolean[] result = new boolean[length];
        int byteIndex = byteOffset + bitOffset / 8;
        int bitIndex = bitOffset % 8;
        for (int i = 0; i < length; ++i) {
            int value = 0;
            if (bitOrder == BitOrder.MSB_0) {
                value = bytes[byteIndex] & 128 >>> bitIndex;
            } else if (bitOrder == BitOrder.LSB_0) {
                value = bytes[byteIndex] & 1 << bitIndex;
            } else {
                throw new IllegalArgumentException("mode must be MSB_0 or LSB_0");
            }
            boolean bl = result[i] = value != 0;
            if (++bitIndex != 8) continue;
            bitIndex = 0;
            ++byteIndex;
        }
        return result;
    }

    public void encode(byte[] bytes, int byteOffset, int bitOffset, BitOrder bitOrder, boolean[] values) {
        int byteIndex = byteOffset + bitOffset / 8;
        int bitIndex = bitOffset % 8;
        for (boolean value : values) {
            if (bitOrder == BitOrder.MSB_0) {
                if (value) {
                    int n = byteIndex;
                    bytes[n] = (byte)(bytes[n] | 128 >>> bitIndex);
                } else {
                    int n = byteIndex;
                    bytes[n] = (byte)(bytes[n] & ~(128 >>> bitIndex));
                }
            } else if (bitOrder == BitOrder.LSB_0) {
                if (value) {
                    int n = byteIndex;
                    bytes[n] = (byte)(bytes[n] | 1 << bitIndex);
                } else {
                    int n = byteIndex;
                    bytes[n] = (byte)(bytes[n] & ~(1 << bitIndex));
                }
            } else {
                throw new IllegalArgumentException("mode must be MSB_0 or LSB_0");
            }
            if (++bitIndex != 8) continue;
            bitIndex = 0;
            ++byteIndex;
        }
    }

    public class CollectionCodec
    implements Codec<Collection<Boolean>> {
        @Override
        public Collection<Boolean> decode(CodecContext context, byte[] bytes) {
            try {
                Class<?> type = context.getFieldType();
                Collection collection = CollectionUtils.newInstance(type);
                for (boolean value : BoolArrayCodec.this.decode(context, bytes)) {
                    collection.add(value);
                }
                return collection;
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new DecodingException(String.format("Fail decoding collection type of %s", context.getFieldType().toString()), (Throwable)e);
            }
        }

        @Override
        public void encode(CodecContext context, byte[] bytes, Collection<Boolean> collection) {
            boolean[] bools = new boolean[collection.size()];
            Boolean[] values = (Boolean[])collection.stream().toArray(Boolean[]::new);
            IntStream.range(0, values.length).forEach(i -> {
                bools[i] = values[i];
            });
            BoolArrayCodec.this.encode(context, bytes, bools);
        }
    }

    public class WrapperCodec
    implements Codec<Boolean[]> {
        @Override
        public Boolean[] decode(CodecContext context, byte[] bytes) {
            boolean[] bools = BoolArrayCodec.this.decode(context, bytes);
            Boolean[] results = new Boolean[bools.length];
            IntStream.range(0, bools.length).forEach(i -> {
                results[i] = bools[i];
            });
            return results;
        }

        @Override
        public void encode(CodecContext context, byte[] bytes, Boolean[] values) {
            boolean[] bools = new boolean[values.length];
            IntStream.range(0, values.length).forEach(i -> {
                bools[i] = values[i];
            });
            BoolArrayCodec.this.encode(context, bytes, bools);
        }
    }
}

