/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import java.util.Arrays;
import org.indunet.fastproto.BitOrder;
import org.indunet.fastproto.annotation.BoolType;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;

public class BoolCodec
implements Codec<Boolean> {
    public boolean decode(byte[] bytes, int byteOffset, int bitOffset) {
        try {
            return CodecUtils.boolType(bytes, byteOffset, bitOffset);
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new DecodingException("Fail decoding boolean type.", (Throwable)e);
        }
    }

    public void encode(byte[] datagram, int byteOffset, int bitOffset, boolean value) {
        try {
            CodecUtils.boolType(datagram, byteOffset, bitOffset, value);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            throw new EncodingException("Fail encoding the boolean type.", (Throwable)e);
        }
    }

    @Override
    public Boolean decode(CodecContext context, byte[] bytes) {
        BoolType type = context.getDataTypeAnnotation(BoolType.class);
        BitOrder bitOrder = Arrays.stream(type.bitOrder()).findFirst().orElseGet(context::getDefaultBitOrder);
        if (bitOrder == BitOrder.LSB_0) {
            return this.decode(bytes, type.byteOffset(), type.bitOffset());
        }
        if (bitOrder == BitOrder.MSB_0) {
            return this.decode(bytes, type.byteOffset(), 7 - type.bitOffset());
        }
        throw new DecodingException("Illegal mode, only LSB_0 or MSB_0 can be used.");
    }

    @Override
    public void encode(CodecContext context, byte[] bytes, Boolean value) {
        BoolType type = context.getDataTypeAnnotation(BoolType.class);
        BitOrder bitOrder = Arrays.stream(type.bitOrder()).findFirst().orElseGet(context::getDefaultBitOrder);
        if (bitOrder == BitOrder.LSB_0) {
            this.encode(bytes, type.byteOffset(), type.bitOffset(), value);
        } else if (bitOrder == BitOrder.MSB_0) {
            this.encode(bytes, type.byteOffset(), 7 - type.bitOffset(), value);
        } else {
            throw new EncodingException("Illegal mode, only LSB_0 or MSB_0 can be used.");
        }
    }
}

