/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import java.util.Arrays;
import org.indunet.fastproto.ByteOrder;
import org.indunet.fastproto.annotation.CharType;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;

public class CharCodec
implements Codec<Character> {
    public Character decode(byte[] datagram, int offset, ByteOrder byteOrder) {
        try {
            return Character.valueOf((char)CodecUtils.uint16Type(datagram, offset, byteOrder));
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DecodingException("Fail decoding char type.", (Throwable)e);
        }
    }

    public void encode(byte[] datagram, int offset, ByteOrder byteOrder, char value) {
        try {
            CodecUtils.uint16Type(datagram, offset, byteOrder, (int)value);
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new EncodingException("Fail encoding char type.", (Throwable)e);
        }
    }

    @Override
    public Character decode(CodecContext context, byte[] bytes) {
        CharType type = context.getDataTypeAnnotation(CharType.class);
        ByteOrder policy = Arrays.stream(type.byteOrder()).findFirst().orElseGet(context::getDefaultByteOrder);
        return this.decode(bytes, type.offset(), policy);
    }

    @Override
    public void encode(CodecContext context, byte[] bytes, Character value) {
        CharType type = context.getDataTypeAnnotation(CharType.class);
        ByteOrder policy = Arrays.stream(type.byteOrder()).findFirst().orElseGet(context::getDefaultByteOrder);
        this.encode(bytes, type.offset(), policy, value.charValue());
    }
}

