/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import java.util.Arrays;
import java.util.Collection;
import java.util.stream.IntStream;
import org.indunet.fastproto.ByteOrder;
import org.indunet.fastproto.annotation.FloatArrayType;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;
import org.indunet.fastproto.util.CollectionUtils;

public class FloatArrayCodec
implements Codec<float[]> {
    public float[] decode(byte[] bytes, int offset, int length, ByteOrder policy) {
        try {
            int o = CodecUtils.reverse(bytes, offset);
            int l = length;
            if (l < 0) {
                l = CodecUtils.reverse(bytes, offset, length * 4) / 4 + 1;
            }
            float[] values = new float[l];
            IntStream.range(0, l).forEach(i -> {
                values[i] = CodecUtils.floatType(bytes, o + i * 4, policy);
            });
            return values;
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new DecodingException("Fail decoding float array type.", (Throwable)e);
        }
    }

    public void encode(byte[] bytes, int offset, int length, ByteOrder byteOrder, float[] values) {
        try {
            int l = length;
            if (l < 0) {
                l = CodecUtils.reverse(bytes, offset, length * 4) / 4 + 1;
            }
            if (l >= values.length) {
                IntStream.range(0, values.length).forEach(i -> CodecUtils.floatType(bytes, offset + i * 4, byteOrder, values[i]));
            } else {
                IntStream.range(0, l).forEach(i -> CodecUtils.floatType(bytes, offset + i * 4, byteOrder, values[i]));
            }
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new EncodingException("Fail encoding float array type.", (Throwable)e);
        }
    }

    @Override
    public float[] decode(CodecContext context, byte[] bytes) {
        FloatArrayType type = context.getDataTypeAnnotation(FloatArrayType.class);
        ByteOrder byteOrder = Arrays.stream(type.byteOrder()).findFirst().orElseGet(context::getDefaultByteOrder);
        return this.decode(bytes, type.offset(), type.length(), byteOrder);
    }

    @Override
    public void encode(CodecContext context, byte[] bytes, float[] value) {
        FloatArrayType type = context.getDataTypeAnnotation(FloatArrayType.class);
        ByteOrder policy = Arrays.stream(type.byteOrder()).findFirst().orElseGet(context::getDefaultByteOrder);
        this.encode(bytes, type.offset(), type.length(), policy, value);
    }

    public class CollectionCodec
    implements Codec<Collection<Float>> {
        @Override
        public Collection<Float> decode(CodecContext context, byte[] bytes) {
            try {
                Class<?> type = context.getFieldType();
                Collection collection = CollectionUtils.newInstance(type);
                for (float b : FloatArrayCodec.this.decode(context, bytes)) {
                    collection.add(Float.valueOf(b));
                }
                return collection;
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new DecodingException(String.format("Fail decoding collection type of %s", context.getFieldType().toString()), (Throwable)e);
            }
        }

        @Override
        public void encode(CodecContext context, byte[] bytes, Collection<Float> collection) {
            float[] bs = new float[collection.size()];
            Float[] values = (Float[])collection.stream().toArray(Float[]::new);
            IntStream.range(0, bs.length).forEach(i -> {
                bs[i] = values[i].floatValue();
            });
            FloatArrayCodec.this.encode(context, bytes, bs);
        }
    }

    public class WrapperCodec
    implements Codec<Float[]> {
        @Override
        public Float[] decode(CodecContext context, byte[] bytes) {
            float[] floats = FloatArrayCodec.this.decode(context, bytes);
            Float[] values = new Float[floats.length];
            IntStream.range(0, floats.length).forEach(i -> {
                values[i] = Float.valueOf(floats[i]);
            });
            return values;
        }

        @Override
        public void encode(CodecContext context, byte[] bytes, Float[] values) {
            float[] floats = new float[values.length];
            IntStream.range(0, floats.length).forEach(i -> {
                floats[i] = values[i].floatValue();
            });
            FloatArrayCodec.this.encode(context, bytes, floats);
        }
    }
}

