/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import java.util.Arrays;
import org.indunet.fastproto.ByteOrder;
import org.indunet.fastproto.annotation.Int16Type;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;

public class Int16Codec
implements Codec<Integer> {
    public int decode(byte[] bytes, int byteOffset, ByteOrder byteOrder) {
        try {
            return CodecUtils.int16Type(bytes, byteOffset, byteOrder);
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new DecodingException("Fail decoding int16(int) type.", (Throwable)e);
        }
    }

    public void encode(byte[] bytes, int offset, ByteOrder byteOrder, int value) {
        try {
            CodecUtils.int16Type(bytes, offset, byteOrder, value);
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new EncodingException("Fail encoding int16(int) type.", (Throwable)e);
        }
    }

    @Override
    public Integer decode(CodecContext context, byte[] bytes) {
        Int16Type type = context.getDataTypeAnnotation(Int16Type.class);
        ByteOrder byteOrder = Arrays.stream(type.byteOrder()).findFirst().orElseGet(context::getDefaultByteOrder);
        return this.decode(bytes, type.offset(), byteOrder);
    }

    @Override
    public void encode(CodecContext context, byte[] bytes, Integer value) {
        Int16Type type = context.getDataTypeAnnotation(Int16Type.class);
        ByteOrder byteOrder = Arrays.stream(type.byteOrder()).findFirst().orElseGet(context::getDefaultByteOrder);
        this.encode(bytes, type.offset(), byteOrder, value);
    }
}

