/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import java.util.Arrays;
import org.indunet.fastproto.ByteOrder;
import org.indunet.fastproto.annotation.Int32Type;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;

public class Int32Codec
implements Codec<Integer> {
    public int decode(byte[] bytes, int byteOffset, ByteOrder policy) {
        try {
            return CodecUtils.int32Type(bytes, byteOffset, policy);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DecodingException("Fail decoding int32 type.", (Throwable)e);
        }
    }

    public void encode(byte[] bytes, int offset, ByteOrder policy, int value) {
        try {
            CodecUtils.int32Type(bytes, offset, policy, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw new EncodingException("Fail encoding int32 type.", (Throwable)e);
        }
    }

    @Override
    public Integer decode(CodecContext context, byte[] bytes) {
        Int32Type type = context.getDataTypeAnnotation(Int32Type.class);
        ByteOrder byteOrder = Arrays.stream(type.byteOrder()).findFirst().orElseGet(context::getDefaultByteOrder);
        return this.decode(bytes, type.offset(), byteOrder);
    }

    @Override
    public void encode(CodecContext context, byte[] bytes, Integer value) {
        Int32Type type = context.getDataTypeAnnotation(Int32Type.class);
        ByteOrder byteOrder = context.getDefaultByteOrder();
        this.encode(bytes, type.offset(), byteOrder, value);
    }
}

