/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import java.util.Arrays;
import org.indunet.fastproto.ByteOrder;
import org.indunet.fastproto.annotation.Int16Type;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;

public class ShortCodec
implements Codec<Short> {
    public short decode(byte[] bytes, int offset, ByteOrder byteOrder) {
        try {
            return CodecUtils.shortType(bytes, offset, byteOrder);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DecodingException("Fail decoding int16(short) type.", (Throwable)e);
        }
    }

    public void encode(byte[] bytes, int offset, ByteOrder byteOrder, short value) {
        try {
            CodecUtils.shortType(bytes, offset, byteOrder, value);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new EncodingException("Fail encoding int16(short) type.", (Throwable)e);
        }
    }

    @Override
    public Short decode(CodecContext context, byte[] bytes) {
        Int16Type type = context.getDataTypeAnnotation(Int16Type.class);
        ByteOrder byteOrder = Arrays.stream(type.byteOrder()).findFirst().orElseGet(context::getDefaultByteOrder);
        return this.decode(bytes, type.offset(), byteOrder);
    }

    @Override
    public void encode(CodecContext context, byte[] bytes, Short value) {
        Int16Type type = context.getDataTypeAnnotation(Int16Type.class);
        ByteOrder byteOrder = Arrays.stream(type.byteOrder()).findFirst().orElseGet(context::getDefaultByteOrder);
        this.encode(bytes, type.offset(), byteOrder, value);
    }
}

