/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import java.util.Arrays;
import java.util.Collection;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.indunet.fastproto.ByteOrder;
import org.indunet.fastproto.annotation.UInt16ArrayType;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;
import org.indunet.fastproto.util.CollectionUtils;

public class UInt16ArrayCodec
implements Codec<int[]> {
    public int[] decode(byte[] bytes, int offset, int length, ByteOrder byteOrder) {
        try {
            int o = CodecUtils.reverse(bytes, offset);
            int l = length;
            if (l < 0) {
                l = CodecUtils.reverse(bytes, offset, length * 2) / 2 + 1;
            }
            return IntStream.range(0, l).map(i -> CodecUtils.uint16Type(bytes, o + i * 2, byteOrder)).toArray();
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new DecodingException("Fail decoding uint16 array type.", (Throwable)e);
        }
    }

    public void encode(byte[] bytes, int offset, int length, ByteOrder byteOrder, int[] values) {
        try {
            int o = CodecUtils.reverse(bytes, offset);
            int l = length;
            if (l < 0) {
                l = CodecUtils.reverse(bytes, offset, length * 2) / 2 + 1;
            }
            IntStream.range(0, l).forEach(i -> CodecUtils.uint16Type(bytes, o + i * 2, byteOrder, values[i]));
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new EncodingException("Fail encoding uint16 array type.", (Throwable)e);
        }
    }

    @Override
    public int[] decode(CodecContext context, byte[] bytes) {
        UInt16ArrayType type = context.getDataTypeAnnotation(UInt16ArrayType.class);
        ByteOrder byteOrder = Arrays.stream(type.byteOrder()).findFirst().orElseGet(context::getDefaultByteOrder);
        return this.decode(bytes, type.offset(), type.length(), byteOrder);
    }

    @Override
    public void encode(CodecContext context, byte[] bytes, int[] value) {
        UInt16ArrayType type = context.getDataTypeAnnotation(UInt16ArrayType.class);
        ByteOrder byteOrder = Arrays.stream(type.byteOrder()).findFirst().orElseGet(context::getDefaultByteOrder);
        this.encode(bytes, type.offset(), type.length(), byteOrder, value);
    }

    public class CollectionCodec
    implements Codec<Collection<Integer>> {
        @Override
        public Collection<Integer> decode(CodecContext context, byte[] bytes) {
            try {
                Class<?> type = context.getFieldType();
                Collection collection = CollectionUtils.newInstance(type);
                Arrays.stream(UInt16ArrayCodec.this.decode(context, bytes)).forEach(collection::add);
                return collection;
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new DecodingException(String.format("Fail decoding collection type of %s", context.getFieldType().toString()), (Throwable)e);
            }
        }

        @Override
        public void encode(CodecContext context, byte[] bytes, Collection<Integer> collection) {
            UInt16ArrayCodec.this.encode(context, bytes, collection.stream().mapToInt(Integer::intValue).toArray());
        }
    }

    public class WrapperCodec
    implements Codec<Integer[]> {
        @Override
        public Integer[] decode(CodecContext context, byte[] bytes) {
            return (Integer[])IntStream.of(UInt16ArrayCodec.this.decode(context, bytes)).mapToObj(Integer::valueOf).toArray(Integer[]::new);
        }

        @Override
        public void encode(CodecContext context, byte[] bytes, Integer[] values) {
            int[] ints = Stream.of(values).mapToInt(i -> i).toArray();
            UInt16ArrayCodec.this.encode(context, bytes, ints);
        }
    }
}

