/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import java.util.Arrays;
import org.indunet.fastproto.ByteOrder;
import org.indunet.fastproto.annotation.UInt16Type;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;

public class UInt16Codec
implements Codec<Integer> {
    public int decode(byte[] bytes, int offset, ByteOrder byteOrder) {
        try {
            return CodecUtils.uint16Type(bytes, offset, byteOrder);
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new DecodingException("Fail decoding uint16 type.", (Throwable)e);
        }
    }

    public void encode(byte[] bytes, int offset, ByteOrder byteOrder, int value) {
        try {
            CodecUtils.uint16Type(bytes, offset, byteOrder, value);
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new EncodingException("Fail encoding uint16 type.", (Throwable)e);
        }
    }

    @Override
    public Integer decode(CodecContext context, byte[] bytes) {
        UInt16Type type = context.getDataTypeAnnotation(UInt16Type.class);
        ByteOrder byteOrder = Arrays.stream(type.byteOrder()).findFirst().orElseGet(context::getDefaultByteOrder);
        return this.decode(bytes, type.offset(), byteOrder);
    }

    @Override
    public void encode(CodecContext context, byte[] bytes, Integer value) {
        UInt16Type type = context.getDataTypeAnnotation(UInt16Type.class);
        ByteOrder byteOrder = Arrays.stream(type.byteOrder()).findFirst().orElseGet(context::getDefaultByteOrder);
        this.encode(bytes, type.offset(), byteOrder, value);
    }
}

