/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.graph;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.indunet.fastproto.exception.ResolveException;
import org.indunet.fastproto.graph.Reference;

public class Graph {
    protected LinkedHashMap<Reference, ArrayList<Reference>> adj = new LinkedHashMap();
    protected List<Reference> validReferences;

    protected Graph() {
    }

    public int countClass() {
        return this.adj.size();
    }

    public int countReference() {
        return this.adj.values().stream().mapToInt(List::size).sum();
    }

    public LinkedHashMap<Reference, ArrayList<Reference>> getAdj() {
        return this.adj;
    }

    public boolean contains(@NonNull Class<?> protocolClass) {
        if (protocolClass == null) {
            throw new NullPointerException("protocolClass is marked non-null but is null");
        }
        return this.adj.keySet().stream().anyMatch(s -> s.getProtocolClass() == protocolClass);
    }

    public boolean contains(@NonNull Reference reference) {
        if (reference == null) {
            throw new NullPointerException("reference is marked non-null but is null");
        }
        return this.adj.keySet().contains(reference);
    }

    public void addClass(@NonNull Reference reference) {
        if (reference == null) {
            throw new NullPointerException("reference is marked non-null but is null");
        }
        if (!this.contains(reference)) {
            this.adj.put(reference, new ArrayList());
        }
    }

    public void addReference(@NonNull Reference parent, @NonNull Reference child) {
        if (parent == null) {
            throw new NullPointerException("parent is marked non-null but is null");
        }
        if (child == null) {
            throw new NullPointerException("child is marked non-null but is null");
        }
        if (this.contains(parent)) {
            this.adj.get(parent).add(child);
        } else {
            this.adj.put(parent, new ArrayList());
            this.adj.get(parent).add(child);
        }
    }

    public void addReference(@NonNull Reference reference) {
        if (reference == null) {
            throw new NullPointerException("reference is marked non-null but is null");
        }
        Reference key = this.adj.keySet().stream().filter(s -> s.getProtocolClass() == reference.getField().getDeclaringClass()).findAny().orElseThrow(ResolveException::new);
        this.addReference(key, reference);
    }

    public Reference getReference(@NonNull Class<?> protocolCLass) {
        if (protocolCLass == null) {
            throw new NullPointerException("protocolCLass is marked non-null but is null");
        }
        return this.adj.keySet().stream().filter(s -> s.getProtocolClass() == protocolCLass).findAny().orElse(null);
    }

    public List<Reference> adj(@NonNull Reference reference) {
        if (reference == null) {
            throw new NullPointerException("reference is marked non-null but is null");
        }
        return this.adj.get(reference);
    }

    public int degree(@NonNull Reference schema) {
        if (schema == null) {
            throw new NullPointerException("schema is marked non-null but is null");
        }
        if (this.adj.containsKey(schema)) {
            return this.adj.get(schema).size();
        }
        return 0;
    }

    public Reference root() {
        return (Reference)this.adj.keySet().stream().findFirst().get();
    }

    public void print() {
        this.adj.entrySet().forEach(entry -> {
            System.out.println(entry.getKey());
            ((ArrayList)entry.getValue()).forEach(s -> System.out.println("\t" + s));
        });
    }

    public synchronized List<Reference> getValidReferences() {
        if (this.validReferences == null) {
            this.validReferences = this.adj.values().stream().flatMap(Collection::stream).filter(r -> r.referenceType == Reference.ReferenceType.FIELD).collect(Collectors.toList());
        }
        return this.validReferences;
    }

    public Stream<Reference> stream() {
        ArrayList list = new ArrayList();
        this.foreach(list::add);
        return list.stream();
    }

    public void foreach(Consumer<Reference> consumer) {
        ArrayDeque<Reference> queue = new ArrayDeque<Reference>();
        HashSet<Reference> marks = new HashSet<Reference>();
        queue.add(this.root());
        marks.add(this.root());
        while (!queue.isEmpty()) {
            Reference ref = (Reference)queue.remove();
            consumer.accept(ref);
            this.adj(ref).stream().filter(r -> r.getReferenceType() == Reference.ReferenceType.CLASS).filter(r -> !marks.contains(r)).forEach(r -> {
                queue.add((Reference)r);
                marks.add((Reference)r);
            });
            this.adj(ref).stream().filter(r -> r.getReferenceType() == Reference.ReferenceType.FIELD).forEach(consumer);
        }
    }

    public Object generate() {
        Reference root = this.root();
        this.generate(root);
        Object object = root.getValue().get();
        this.foreach(Reference::clear);
        return object;
    }

    protected void generate(Reference reference) {
        List<Reference> list = this.adj(reference);
        if (reference.getConstructorType() == Reference.ConstructorType.NO_ARGS) {
            reference.newInstance();
            list.stream().filter(r -> r.getReferenceType() != Reference.ReferenceType.INVALID).forEach(r -> {
                if (r.getReferenceType() == Reference.ReferenceType.CLASS && r.getValue().get() == null) {
                    this.generate((Reference)r);
                }
                reference.setField((Reference)r);
            });
        } else if (reference.getConstructorType() == Reference.ConstructorType.ALL_ARGS) {
            list.stream().filter(r -> r.getReferenceType() == Reference.ReferenceType.CLASS).forEach(this::generate);
            reference.newInstance(list.toArray(new Reference[list.size()]));
        }
    }

    public void copy(Object object) {
        HashSet<Reference> marks = new HashSet<Reference>();
        ArrayDeque<Reference> queue = new ArrayDeque<Reference>();
        marks.add(this.root());
        queue.add(this.root());
        while (!queue.isEmpty()) {
            Reference ref = (Reference)queue.remove();
            Object obj = ref.parse(object);
            if (obj == null) continue;
            this.adj(ref).stream().filter(r -> r.getReferenceType() == Reference.ReferenceType.FIELD).filter(r -> r.getEncodingIgnore() == false).forEach(r -> r.setValue(r.parse(obj)));
            for (Reference r2 : this.adj(ref)) {
                if (r2.getReferenceType() != Reference.ReferenceType.CLASS || marks.contains(r2)) continue;
                queue.add(r2);
                marks.add(r2);
            }
        }
    }
}

