/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.graph.resolve;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.function.Function;
import org.indunet.fastproto.annotation.DecodingFormula;
import org.indunet.fastproto.annotation.EncodingFormula;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.formula.FormulaBuilder;
import org.indunet.fastproto.graph.Reference;
import org.indunet.fastproto.graph.resolve.ResolvePipeline;
import org.indunet.fastproto.mapper.JavaTypeMapper;

public class FormulaFlow
extends ResolvePipeline {
    @Override
    public void process(Reference reference) {
        FormulaBuilder builder;
        Class<?> inputType;
        Class<Function<?, ?>> clazz;
        Annotation formula;
        Field field = reference.getField();
        if (field.isAnnotationPresent(DecodingFormula.class)) {
            formula = field.getAnnotation(DecodingFormula.class);
            if (formula.value().length != 0) {
                clazz = formula.value()[0];
                try {
                    reference.setDecodingFormulaClass(clazz);
                    reference.setDecodingFormula(clazz.newInstance());
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new DecodingException(String.format("fail initializing formula %s", clazz.getSimpleName()), (Throwable)e);
                }
            } else if (!formula.lambda().isEmpty()) {
                inputType = JavaTypeMapper.get(reference.getDataTypeAnnotation().annotationType());
                builder = FormulaBuilder.create(inputType, formula.lambda());
                reference.setDecodingLambda(builder.build());
            } else {
                throw new DecodingException(String.format("value and lambda of @DecodingFormula of %s should not be empty at the same time.", reference.getField().toString()));
            }
        }
        if (field.isAnnotationPresent(EncodingFormula.class)) {
            formula = field.getAnnotation(EncodingFormula.class);
            if (formula.value().length != 0) {
                clazz = formula.value()[0];
                try {
                    reference.setEncodingFormulaClass(clazz);
                    reference.setEncodingFormula(clazz.newInstance());
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new EncodingException(String.format("fail initializing formula %s", clazz.getSimpleName()), (Throwable)e);
                }
            } else if (!formula.lambda().isEmpty()) {
                inputType = reference.getField().getType();
                builder = FormulaBuilder.create(inputType, formula.lambda());
                reference.setEncodingLambda(builder.build());
            } else {
                throw new EncodingException(String.format("value and lambda of @EncodingFormula of %s should not be empty at the same time.", reference.getField().toString()));
            }
        }
        this.forward(reference);
    }
}

