/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.pipeline.decode;

import java.text.MessageFormat;
import java.util.List;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.graph.Graph;
import org.indunet.fastproto.graph.Reference;
import org.indunet.fastproto.pipeline.Pipeline;
import org.indunet.fastproto.pipeline.PipelineContext;

public class DecodeFlow
extends Pipeline<PipelineContext> {
    @Override
    public void process(PipelineContext context) {
        Reference reference = context.getGraph().root();
        byte[] datagram = context.getBytes();
        context.setObject(this.linearDecode(datagram, context.getGraph()));
        this.forward(context);
    }

    public Object linearDecode(byte[] bytes, Graph graph) {
        List<Reference> refs = graph.getValidReferences();
        refs.stream().filter(r -> r.getDecodingIgnore() == false).forEach(r -> {
            try {
                r.decode(bytes);
            }
            catch (DecodingException e) {
                throw new DecodingException(MessageFormat.format(CodecError.FAIL_DECODING_FIELD.getMessage(), r.getField().toString()), (Throwable)e);
            }
        });
        return graph.generate();
    }

    @Override
    public long getCode() {
        return 1L;
    }
}

