/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.util;

import java.math.BigInteger;
import java.util.Arrays;
import lombok.NonNull;
import org.indunet.fastproto.BitOrder;
import org.indunet.fastproto.ByteBuffer;
import org.indunet.fastproto.ByteOrder;
import org.indunet.fastproto.annotation.UInt64Type;

public class CodecUtils {
    public static int reverse(@NonNull byte[] datagram, int offset) {
        int o;
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        int n = o = offset >= 0 ? offset : datagram.length + offset;
        if (o >= 0) {
            return o;
        }
        throw new IllegalArgumentException(String.format("Illegal offset %d", o));
    }

    public static int reverse(@NonNull byte[] datagram, int offset, int length) {
        int l;
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        int o = CodecUtils.reverse(datagram, offset);
        int n = l = length >= 0 ? length : datagram.length + length - o + 1;
        if (l > 0) {
            return l;
        }
        throw new IllegalArgumentException(String.format("Illegal length %d", l));
    }

    public static byte[] binaryType(@NonNull byte[] datagram, int offset, int length) {
        int l;
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        int o = CodecUtils.reverse(datagram, offset);
        if (o + (l = CodecUtils.reverse(datagram, offset, length)) > datagram.length) {
            throw new IllegalArgumentException("Out of the datagram range.");
        }
        return Arrays.copyOfRange(datagram, o, o + l);
    }

    public static void binaryType(@NonNull byte[] datagram, int offset, int length, @NonNull byte[] values) {
        int l;
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        int o = CodecUtils.reverse(datagram, offset);
        if (o + (l = CodecUtils.reverse(datagram, offset, length)) > datagram.length) {
            throw new IllegalArgumentException("Out of the datagram range.");
        }
        if (l >= values.length) {
            System.arraycopy(values, 0, datagram, o, values.length);
        } else {
            System.arraycopy(values, 0, datagram, o, l);
        }
    }

    public static void type(@NonNull byte[] datagram, int offset, int length, @NonNull byte[] values) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        CodecUtils.binaryType(datagram, offset, length, values);
    }

    public static void type(@NonNull byte[] datagram, int offset, @NonNull byte[] values) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        CodecUtils.binaryType(datagram, offset, values.length, values);
    }

    public static boolean boolType(@NonNull byte[] datagram, int byteOffset, int bitOffset) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (bitOffset < 0 || bitOffset > 7) {
            throw new IllegalArgumentException("Out of byte range.");
        }
        int o = CodecUtils.reverse(datagram, byteOffset);
        return (datagram[o] & 1 << bitOffset) != 0;
    }

    public static void boolType(@NonNull byte[] datagram, int byteOffset, int bitOffset, boolean value) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (bitOffset < 0 || bitOffset > 7) {
            throw new IllegalArgumentException("Out of byte range.");
        }
        int o = CodecUtils.reverse(datagram, byteOffset);
        if (value) {
            int n = o;
            datagram[n] = (byte)(datagram[n] | 1 << bitOffset);
        } else {
            int n = o;
            datagram[n] = (byte)(datagram[n] & ~(1 << bitOffset));
        }
    }

    public static void boolType(ByteBuffer byteBuffer, int byteOffset, int bitOffset, boolean value) {
        CodecUtils.boolType(byteBuffer, byteOffset, bitOffset, BitOrder.LSB_0, value);
    }

    public static void boolType(ByteBuffer byteBuffer, int byteOffset, int bitOffset, BitOrder bitOrder, boolean value) {
        if (bitOffset < 0 || bitOffset > 7) {
            throw new IllegalArgumentException("Out of byte range.");
        }
        int bo = bitOffset;
        if (bitOrder == BitOrder.MSB_0) {
            bo = 7 - bitOffset;
        }
        if (value) {
            byteBuffer.orEq(byteOffset, (byte)(1 << bo));
        } else {
            byteBuffer.andEq(byteOffset, (byte)(~(1 << bo)));
        }
    }

    public static void type(@NonNull byte[] datagram, int byteOffset, int bitOffset, boolean value) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        CodecUtils.boolType(datagram, byteOffset, bitOffset, value);
    }

    public static byte byteType(ByteBuffer byteBuffer, int offset) {
        return byteBuffer.get(offset);
    }

    public static byte byteType(@NonNull byte[] datagram, int offset) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        int o = CodecUtils.reverse(datagram, offset);
        return datagram[o];
    }

    public static void byteType(@NonNull byte[] datagram, int offset, byte value) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        int o = CodecUtils.reverse(datagram, offset);
        datagram[o] = value;
    }

    public static void byteType(ByteBuffer byteBuffer, int offset, byte value) {
        byteBuffer.set(offset, value);
    }

    public static void type(@NonNull byte[] datagram, int offset, byte value) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        CodecUtils.byteType(datagram, offset, value);
    }

    public static int uint8Type(ByteBuffer byteBuffer, int offset) {
        return byteBuffer.get(offset) & 0xFF;
    }

    public static int uint8Type(@NonNull byte[] datagram, int offset) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        int o = CodecUtils.reverse(datagram, offset);
        return datagram[o] & 0xFF;
    }

    public static void uint8Type(@NonNull byte[] datagram, int offset, @NonNull int value) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (value < 0 || value > 255) {
            throw new IllegalArgumentException("Out of uint8 range.");
        }
        int o = CodecUtils.reverse(datagram, offset);
        datagram[o] = (byte)value;
    }

    public static void uint8Type(ByteBuffer byteArray, int offset, @NonNull int value) {
        if (value < 0 || value > 255) {
            throw new IllegalArgumentException("Out of uint8 range.");
        }
        int o = CodecUtils.reverse(byteArray.getBytes(), offset);
        byteArray.set(o, (byte)value);
    }

    public static int int8Type(ByteBuffer byteBuffer, int offset) {
        return byteBuffer.get(offset);
    }

    public static int int8Type(@NonNull byte[] datagram, int offset) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        int o = CodecUtils.reverse(datagram, offset);
        return datagram[o];
    }

    public static void int8Type(@NonNull byte[] datagram, int offset, @NonNull int value) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (value < -128 || value > 127) {
            throw new IllegalArgumentException("Out of int8 range.");
        }
        int o = CodecUtils.reverse(datagram, offset);
        datagram[o] = (byte)value;
    }

    public static void int8Type(ByteBuffer byteBuffer, int offset, @NonNull int value) {
        if (value < -128 || value > 127) {
            throw new IllegalArgumentException("Out of int8 range.");
        }
        byteBuffer.set(offset, (byte)value);
    }

    public static int uint16Type(@NonNull byte[] datagram, int offset, ByteOrder byteOrder) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        int o = CodecUtils.reverse(datagram, offset);
        if (byteOrder == ByteOrder.BIG) {
            return (datagram[o] & 0xFF) * 256 + (datagram[o + 1] & 0xFF);
        }
        return (datagram[o + 1] & 0xFF) * 256 + (datagram[o] & 0xFF);
    }

    public static int uint16Type(ByteBuffer byteBuffer, int offset, ByteOrder byteOrder) {
        if (byteOrder == ByteOrder.BIG) {
            return (byteBuffer.get(offset) & 0xFF) * 256 + (byteBuffer.get(offset + 1) & 0xFF);
        }
        return (byteBuffer.get(offset) & 0xFF) + (byteBuffer.get(offset + 1) & 0xFF) * 256;
    }

    public static int uint16Type(@NonNull byte[] datagram, int offset) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        return CodecUtils.uint16Type(datagram, offset, ByteOrder.LITTLE);
    }

    public static void uint16Type(@NonNull byte[] datagram, int offset, ByteOrder byteOrder, @NonNull int value) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (value < 0 || value > 65535) {
            throw new IllegalArgumentException("Out of uint16 range.");
        }
        int o = CodecUtils.reverse(datagram, offset);
        if (byteOrder == ByteOrder.BIG) {
            datagram[o + 1] = (byte)value;
            datagram[o] = (byte)(value >>> 8);
        } else {
            datagram[o] = (byte)value;
            datagram[o + 1] = (byte)(value >>> 8);
        }
    }

    public static void uint16Type(ByteBuffer byteBuffer, int offset, ByteOrder byteOrder, @NonNull int value) {
        if (value < 0 || value > 65535) {
            throw new IllegalArgumentException("Out of uint16 range.");
        }
        if (byteOrder == ByteOrder.BIG) {
            byteBuffer.set(offset + 1, (byte)value);
            byteBuffer.set(offset, (byte)(value >>> 8));
        } else {
            byteBuffer.set(offset, (byte)value);
            byteBuffer.set(offset + 1, (byte)(value >>> 8));
        }
    }

    public static void uint16Type(@NonNull byte[] datagram, int offset, @NonNull int value) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        CodecUtils.uint16Type(datagram, offset, ByteOrder.LITTLE, value);
    }

    public static int int16Type(@NonNull byte[] datagram, int offset, ByteOrder byteOrder) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        int o = CodecUtils.reverse(datagram, offset);
        int value = 0;
        if (byteOrder == ByteOrder.BIG) {
            value = (short)(value | datagram[o + 1] & 0xFF);
            value = (short)(value | datagram[o] << 8);
        } else {
            value = (short)(value | datagram[o] & 0xFF);
            value = (short)(value | datagram[o + 1] << 8);
        }
        return value;
    }

    public static int int16Type(ByteBuffer byteBuffer, int offset, ByteOrder byteOrder) {
        int value = 0;
        if (byteOrder == ByteOrder.BIG) {
            value = (short)(value | byteBuffer.get(offset) << 8);
            value = (short)(value | byteBuffer.get(offset + 1) & 0xFF);
        } else {
            value = (short)(value | byteBuffer.get(offset) & 0xFF);
            value = (short)(value | byteBuffer.get(offset + 1) << 8);
        }
        return value;
    }

    public static int int16Type(@NonNull byte[] datagram, int offset) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        return CodecUtils.int16Type(datagram, offset, ByteOrder.LITTLE);
    }

    public static void int16Type(@NonNull byte[] datagram, int offset, ByteOrder byteOrder, @NonNull int value) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (value < Short.MIN_VALUE || value > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Out of int16 range.");
        }
        int o = CodecUtils.reverse(datagram, offset);
        if (byteOrder == ByteOrder.BIG) {
            datagram[o + 1] = (byte)value;
            datagram[o] = (byte)(value >>> 8);
        } else {
            datagram[o] = (byte)value;
            datagram[o + 1] = (byte)(value >>> 8);
        }
    }

    public static void int16Type(ByteBuffer byteBuffer, int offset, ByteOrder byteOrder, @NonNull int value) {
        if (value < Short.MIN_VALUE || value > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Out of int16 range.");
        }
        if (byteOrder == ByteOrder.BIG) {
            byteBuffer.set(offset + 1, (byte)value);
            byteBuffer.set(offset, (byte)(value >>> 8));
        } else {
            byteBuffer.set(offset, (byte)value);
            byteBuffer.set(offset + 1, (byte)(value >>> 8));
        }
    }

    public static void int16Type(@NonNull byte[] datagram, int offset, @NonNull int value) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        CodecUtils.int16Type(datagram, offset, ByteOrder.LITTLE, value);
    }

    public static short shortType(@NonNull byte[] datagram, int offset, ByteOrder byteOrder) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        int o = CodecUtils.reverse(datagram, offset);
        short value = 0;
        if (byteOrder == ByteOrder.LITTLE) {
            value = (short)(value | datagram[o] & 0xFF);
            value = (short)(value | datagram[o + 1] << 8);
        } else if (byteOrder == ByteOrder.BIG) {
            value = (short)(value | datagram[o + 1] & 0xFF);
            value = (short)(value | datagram[o] << 8);
        }
        return value;
    }

    public static short shortType(ByteBuffer byteBuffer, int offset, ByteOrder byteOrder) {
        short value = 0;
        if (byteOrder == ByteOrder.LITTLE) {
            value = (short)(value | byteBuffer.get(offset) & 0xFF);
            value = (short)(value | byteBuffer.get(offset + 1) << 8);
        } else if (byteOrder == ByteOrder.BIG) {
            value = (short)(value | byteBuffer.get(offset) << 8);
            value = (short)(value | byteBuffer.get(offset + 1) & 0xFF);
        }
        return value;
    }

    public static short shortType(@NonNull byte[] datagram, int offset) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        return CodecUtils.shortType(datagram, offset, ByteOrder.LITTLE);
    }

    public static void shortType(@NonNull byte[] datagram, int offset, ByteOrder byteOrder, @NonNull short value) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        int o = CodecUtils.reverse(datagram, offset);
        if (byteOrder == ByteOrder.LITTLE) {
            datagram[o] = (byte)value;
            datagram[o + 1] = (byte)(value >>> 8);
        } else if (byteOrder == ByteOrder.BIG) {
            datagram[o + 1] = (byte)value;
            datagram[o] = (byte)(value >>> 8);
        }
    }

    public static void shortType(@NonNull byte[] datagram, int offset, @NonNull short value) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        CodecUtils.shortType(datagram, offset, ByteOrder.LITTLE, value);
    }

    public static void type(@NonNull byte[] datagram, int offset, ByteOrder byteOrder, @NonNull short value) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        CodecUtils.shortType(datagram, offset, byteOrder, value);
    }

    public static int int32Type(@NonNull byte[] datagram, int offset, ByteOrder byteOrder) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        int o = CodecUtils.reverse(datagram, offset);
        int value = 0;
        if (byteOrder == ByteOrder.LITTLE) {
            value |= datagram[o] & 0xFF;
            value |= (datagram[o + 1] & 0xFF) << 8;
            value |= (datagram[o + 2] & 0xFF) << 16;
            value |= (datagram[o + 3] & 0xFF) << 24;
        } else if (byteOrder == ByteOrder.BIG) {
            value |= datagram[o + 3] & 0xFF;
            value |= (datagram[o + 2] & 0xFF) << 8;
            value |= (datagram[o + 1] & 0xFF) << 16;
            value |= (datagram[o] & 0xFF) << 24;
        }
        return value;
    }

    public static int int32Type(ByteBuffer byteBuffer, int offset, ByteOrder byteOrder) {
        int value = 0;
        if (byteOrder == ByteOrder.LITTLE) {
            value |= byteBuffer.get(offset) & 0xFF;
            value |= (byteBuffer.get(offset + 1) & 0xFF) << 8;
            value |= (byteBuffer.get(offset + 2) & 0xFF) << 16;
            value |= (byteBuffer.get(offset + 3) & 0xFF) << 24;
        } else if (byteOrder == ByteOrder.BIG) {
            value |= (byteBuffer.get(offset) & 0xFF) << 24;
            value |= (byteBuffer.get(offset + 1) & 0xFF) << 16;
            value |= (byteBuffer.get(offset + 2) & 0xFF) << 8;
            value |= byteBuffer.get(offset + 3) & 0xFF;
        }
        return value;
    }

    public static int int32Type(@NonNull byte[] datagram, int offset) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        return CodecUtils.int32Type(datagram, offset, ByteOrder.LITTLE);
    }

    public static void int32Type(@NonNull byte[] datagram, int offset, ByteOrder byteOrder, @NonNull int value) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        int o = CodecUtils.reverse(datagram, offset);
        if (byteOrder == ByteOrder.LITTLE) {
            datagram[o] = (byte)value;
            datagram[o + 1] = (byte)(value >>> 8);
            datagram[o + 2] = (byte)(value >>> 16);
            datagram[o + 3] = (byte)(value >>> 24);
        } else if (byteOrder == ByteOrder.BIG) {
            datagram[o + 3] = (byte)value;
            datagram[o + 2] = (byte)(value >>> 8);
            datagram[o + 1] = (byte)(value >>> 16);
            datagram[o] = (byte)(value >>> 24);
        }
    }

    public static void int32Type(ByteBuffer byteBuffer, int offset, ByteOrder byteOrder, @NonNull int value) {
        if (byteOrder == ByteOrder.LITTLE) {
            byteBuffer.set(offset, (byte)value);
            byteBuffer.set(offset + 1, (byte)(value >>> 8));
            byteBuffer.set(offset + 2, (byte)(value >>> 16));
            byteBuffer.set(offset + 3, (byte)(value >>> 24));
        } else if (byteOrder == ByteOrder.BIG) {
            byteBuffer.set(offset + 3, (byte)value);
            byteBuffer.set(offset + 2, (byte)(value >>> 8));
            byteBuffer.set(offset + 1, (byte)(value >>> 16));
            byteBuffer.set(offset, (byte)(value >>> 24));
        }
    }

    public static void int32Type(@NonNull byte[] datagram, int offset, @NonNull int value) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        CodecUtils.int32Type(datagram, offset, ByteOrder.LITTLE, value);
    }

    public static void type(@NonNull byte[] datagram, int offset, ByteOrder byteOrder, @NonNull int value) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        CodecUtils.int32Type(datagram, offset, byteOrder, value);
    }

    public static long uint32Type(@NonNull byte[] datagram, int offset, ByteOrder byteOrder) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        int o = CodecUtils.reverse(datagram, offset);
        long value = 0L;
        if (byteOrder == ByteOrder.LITTLE) {
            value |= (long)(datagram[o] & 0xFF);
            value |= ((long)datagram[o + 1] & 0xFFL) << 8;
            value |= ((long)datagram[o + 2] & 0xFFL) << 16;
            value |= ((long)datagram[o + 3] & 0xFFL) << 24;
        } else if (byteOrder == ByteOrder.BIG) {
            value |= (long)(datagram[o + 3] & 0xFF);
            value |= ((long)datagram[o + 2] & 0xFFL) << 8;
            value |= ((long)datagram[o + 1] & 0xFFL) << 16;
            value |= ((long)datagram[o] & 0xFFL) << 24;
        }
        return value;
    }

    public static long uint32Type(ByteBuffer byteBuffer, int offset, ByteOrder byteOrder) {
        long value = 0L;
        if (byteOrder == ByteOrder.LITTLE) {
            value |= (long)(byteBuffer.get(offset) & 0xFF);
            value |= ((long)byteBuffer.get(offset + 1) & 0xFFL) << 8;
            value |= ((long)byteBuffer.get(offset + 2) & 0xFFL) << 16;
            value |= ((long)byteBuffer.get(offset + 3) & 0xFFL) << 24;
        } else if (byteOrder == ByteOrder.BIG) {
            value |= ((long)byteBuffer.get(offset) & 0xFFL) << 24;
            value |= ((long)byteBuffer.get(offset + 1) & 0xFFL) << 16;
            value |= ((long)byteBuffer.get(offset + 2) & 0xFFL) << 8;
            value |= (long)(byteBuffer.get(offset + 3) & 0xFF);
        }
        return value;
    }

    public static long uint32Type(@NonNull byte[] datagram, int offset) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        return CodecUtils.uint32Type(datagram, offset, ByteOrder.LITTLE);
    }

    public static void uint32Type(@NonNull byte[] datagram, int offset, ByteOrder byteOrder, @NonNull long value) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (value < 0L || value > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Out of uint32 range.");
        }
        int o = CodecUtils.reverse(datagram, offset);
        if (byteOrder == ByteOrder.BIG) {
            datagram[o + 3] = (byte)value;
            datagram[o + 2] = (byte)(value >>> 8);
            datagram[o + 1] = (byte)(value >>> 16);
            datagram[o] = (byte)(value >>> 24);
        } else {
            datagram[o] = (byte)value;
            datagram[o + 1] = (byte)(value >>> 8);
            datagram[o + 2] = (byte)(value >>> 16);
            datagram[o + 3] = (byte)(value >>> 24);
        }
    }

    public static void uint32Type(ByteBuffer byteBuffer, int offset, ByteOrder byteOrder, @NonNull long value) {
        if (value < 0L || value > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Out of uint32 range.");
        }
        if (byteOrder == ByteOrder.BIG) {
            byteBuffer.set(offset + 3, (byte)value);
            byteBuffer.set(offset + 2, (byte)(value >>> 8));
            byteBuffer.set(offset + 1, (byte)(value >>> 16));
            byteBuffer.set(offset, (byte)(value >>> 24));
        } else {
            byteBuffer.set(offset, (byte)value);
            byteBuffer.set(offset + 1, (byte)(value >>> 8));
            byteBuffer.set(offset + 2, (byte)(value >>> 16));
            byteBuffer.set(offset + 3, (byte)(value >>> 24));
        }
    }

    public static void uint32Type(@NonNull byte[] datagram, int offset, @NonNull long value) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        CodecUtils.uint32Type(datagram, offset, ByteOrder.LITTLE, value);
    }

    public static BigInteger uint64Type(@NonNull byte[] datagram, int offset, ByteOrder byteOrder) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        int o = CodecUtils.reverse(datagram, offset);
        long low = 0L;
        long high = 0L;
        if (byteOrder == ByteOrder.LITTLE) {
            low |= (long)(datagram[o] & 0xFF);
            low |= ((long)datagram[o + 1] & 0xFFL) << 8;
            low |= ((long)datagram[o + 2] & 0xFFL) << 16;
            low |= ((long)datagram[o + 3] & 0xFFL) << 24;
            high |= (long)datagram[o + 4] & 0xFFL;
            high |= ((long)datagram[o + 5] & 0xFFL) << 8;
            high |= ((long)datagram[o + 6] & 0xFFL) << 16;
            high |= ((long)datagram[o + 7] & 0xFFL) << 24;
        } else if (byteOrder == ByteOrder.BIG) {
            low |= (long)(datagram[o + 7] & 0xFF);
            low |= ((long)datagram[o + 6] & 0xFFL) << 8;
            low |= ((long)datagram[o + 5] & 0xFFL) << 16;
            low |= ((long)datagram[o + 4] & 0xFFL) << 24;
            high |= (long)datagram[o + 3] & 0xFFL;
            high |= ((long)datagram[o + 2] & 0xFFL) << 8;
            high |= ((long)datagram[o + 1] & 0xFFL) << 16;
            high |= ((long)datagram[o] & 0xFFL) << 24;
        }
        return new BigInteger(String.valueOf(high)).multiply(new BigInteger(String.valueOf(0x100000000L))).add(new BigInteger(String.valueOf(low)));
    }

    public static BigInteger uint64Type(ByteBuffer byteBuffer, int offset, ByteOrder byteOrder) {
        long low = 0L;
        long high = 0L;
        if (byteOrder == ByteOrder.LITTLE) {
            low |= (long)(byteBuffer.get(offset) & 0xFF);
            low |= ((long)byteBuffer.get(offset + 1) & 0xFFL) << 8;
            low |= ((long)byteBuffer.get(offset + 2) & 0xFFL) << 16;
            low |= ((long)byteBuffer.get(offset + 3) & 0xFFL) << 24;
            high |= (long)byteBuffer.get(offset + 4) & 0xFFL;
            high |= ((long)byteBuffer.get(offset + 5) & 0xFFL) << 8;
            high |= ((long)byteBuffer.get(offset + 6) & 0xFFL) << 16;
            high |= ((long)byteBuffer.get(offset + 7) & 0xFFL) << 24;
        } else if (byteOrder == ByteOrder.BIG) {
            high |= ((long)byteBuffer.get(offset) & 0xFFL) << 24;
            high |= ((long)byteBuffer.get(offset + 1) & 0xFFL) << 16;
            high |= ((long)byteBuffer.get(offset + 2) & 0xFFL) << 8;
            high |= (long)byteBuffer.get(offset + 3) & 0xFFL;
            low |= ((long)byteBuffer.get(offset + 4) & 0xFFL) << 24;
            low |= ((long)byteBuffer.get(offset + 5) & 0xFFL) << 16;
            low |= ((long)byteBuffer.get(offset + 6) & 0xFFL) << 8;
            low |= (long)(byteBuffer.get(offset + 7) & 0xFF);
        }
        return new BigInteger(String.valueOf(high)).multiply(new BigInteger(String.valueOf(0x100000000L))).add(new BigInteger(String.valueOf(low)));
    }

    public static BigInteger uint64Type(@NonNull byte[] datagram, int offset) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        return CodecUtils.uint64Type(datagram, offset, ByteOrder.LITTLE);
    }

    public static void uint64Type(@NonNull byte[] datagram, int offset, ByteOrder byteOrder, BigInteger value) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (value.compareTo(UInt64Type.MAX_VALUE) > 0 || value.compareTo(UInt64Type.MIN_VALUE) < 0) {
            throw new IllegalArgumentException("Out of uinteger64 range.");
        }
        int o = CodecUtils.reverse(datagram, offset);
        long low = value.and(new BigInteger(String.valueOf(0xFFFFFFFFL))).longValueExact();
        long high = value.shiftRight(32).longValueExact();
        if (byteOrder == ByteOrder.BIG) {
            datagram[o + 7] = (byte)low;
            datagram[o + 6] = (byte)(low >>> 8);
            datagram[o + 5] = (byte)(low >>> 16);
            datagram[o + 4] = (byte)(low >>> 24);
            datagram[o + 3] = (byte)high;
            datagram[o + 2] = (byte)(high >>> 8);
            datagram[o + 1] = (byte)(high >>> 16);
            datagram[o] = (byte)(high >>> 24);
        } else {
            datagram[o] = (byte)low;
            datagram[o + 1] = (byte)(low >>> 8);
            datagram[o + 2] = (byte)(low >>> 16);
            datagram[o + 3] = (byte)(low >>> 24);
            datagram[o + 4] = (byte)high;
            datagram[o + 5] = (byte)(high >>> 8);
            datagram[o + 6] = (byte)(high >>> 16);
            datagram[o + 7] = (byte)(high >>> 24);
        }
    }

    public static void uint64Type(ByteBuffer byteBuffer, int offset, ByteOrder byteOrder, BigInteger value) {
        if (value.compareTo(UInt64Type.MAX_VALUE) > 0 || value.compareTo(UInt64Type.MIN_VALUE) < 0) {
            throw new IllegalArgumentException("Out of uinteger64 range.");
        }
        long low = value.and(new BigInteger(String.valueOf(0xFFFFFFFFL))).longValueExact();
        long high = value.shiftRight(32).longValueExact();
        if (byteOrder == ByteOrder.BIG) {
            byteBuffer.set(offset + 7, (byte)low);
            byteBuffer.set(offset + 6, (byte)(low >>> 8));
            byteBuffer.set(offset + 5, (byte)(low >>> 16));
            byteBuffer.set(offset + 4, (byte)(low >>> 24));
            byteBuffer.set(offset + 3, (byte)high);
            byteBuffer.set(offset + 2, (byte)(high >>> 8));
            byteBuffer.set(offset + 1, (byte)(high >>> 16));
            byteBuffer.set(offset, (byte)(high >>> 24));
        } else {
            byteBuffer.set(offset, (byte)low);
            byteBuffer.set(offset + 1, (byte)(low >>> 8));
            byteBuffer.set(offset + 2, (byte)(low >>> 16));
            byteBuffer.set(offset + 3, (byte)(low >>> 24));
            byteBuffer.set(offset + 4, (byte)high);
            byteBuffer.set(offset + 5, (byte)(high >>> 8));
            byteBuffer.set(offset + 6, (byte)(high >>> 16));
            byteBuffer.set(offset + 7, (byte)(high >>> 24));
        }
    }

    public static void uint64Type(@NonNull byte[] datagram, int offset, BigInteger value) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        CodecUtils.uint64Type(datagram, offset, ByteOrder.LITTLE, value);
    }

    public static void type(@NonNull byte[] datagram, int offset, ByteOrder byteOrder, @NonNull BigInteger value) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        CodecUtils.uint64Type(datagram, offset, byteOrder, value);
    }

    public static long int64Type(@NonNull byte[] datagram, int offset, ByteOrder byteOrder) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        int o = CodecUtils.reverse(datagram, offset);
        long value = 0L;
        if (byteOrder == ByteOrder.LITTLE) {
            value |= (long)(datagram[o] & 0xFF);
            value |= ((long)datagram[o + 1] & 0xFFL) << 8;
            value |= ((long)datagram[o + 2] & 0xFFL) << 16;
            value |= ((long)datagram[o + 3] & 0xFFL) << 24;
            value |= ((long)datagram[o + 4] & 0xFFL) << 32;
            value |= ((long)datagram[o + 5] & 0xFFL) << 40;
            value |= ((long)datagram[o + 6] & 0xFFL) << 48;
            value |= ((long)datagram[o + 7] & 0xFFL) << 56;
        } else if (byteOrder == ByteOrder.BIG) {
            value |= (long)(datagram[o + 7] & 0xFF);
            value |= ((long)datagram[o + 6] & 0xFFL) << 8;
            value |= ((long)datagram[o + 5] & 0xFFL) << 16;
            value |= ((long)datagram[o + 4] & 0xFFL) << 24;
            value |= ((long)datagram[o + 3] & 0xFFL) << 32;
            value |= ((long)datagram[o + 2] & 0xFFL) << 40;
            value |= ((long)datagram[o + 1] & 0xFFL) << 48;
            value |= ((long)datagram[o] & 0xFFL) << 56;
        }
        return value;
    }

    public static long int64Type(ByteBuffer byteBuffer, int offset, ByteOrder byteOrder) {
        long value = 0L;
        if (byteOrder == ByteOrder.LITTLE) {
            value |= (long)(byteBuffer.get(offset) & 0xFF);
            value |= ((long)byteBuffer.get(offset + 1) & 0xFFL) << 8;
            value |= ((long)byteBuffer.get(offset + 2) & 0xFFL) << 16;
            value |= ((long)byteBuffer.get(offset + 3) & 0xFFL) << 24;
            value |= ((long)byteBuffer.get(offset + 4) & 0xFFL) << 32;
            value |= ((long)byteBuffer.get(offset + 5) & 0xFFL) << 40;
            value |= ((long)byteBuffer.get(offset + 6) & 0xFFL) << 48;
            value |= ((long)byteBuffer.get(offset + 7) & 0xFFL) << 56;
        } else if (byteOrder == ByteOrder.BIG) {
            value |= ((long)byteBuffer.get(offset) & 0xFFL) << 56;
            value |= ((long)byteBuffer.get(offset + 1) & 0xFFL) << 48;
            value |= ((long)byteBuffer.get(offset + 2) & 0xFFL) << 40;
            value |= ((long)byteBuffer.get(offset + 3) & 0xFFL) << 32;
            value |= ((long)byteBuffer.get(offset + 4) & 0xFFL) << 24;
            value |= ((long)byteBuffer.get(offset + 5) & 0xFFL) << 16;
            value |= ((long)byteBuffer.get(offset + 6) & 0xFFL) << 8;
            value |= (long)(byteBuffer.get(offset + 7) & 0xFF);
        }
        return value;
    }

    public static long int64Type(@NonNull byte[] datagram, int offset) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        return CodecUtils.int64Type(datagram, offset, ByteOrder.LITTLE);
    }

    public static void int64Type(@NonNull byte[] datagram, int offset, ByteOrder byteOrder, @NonNull long value) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        int o = CodecUtils.reverse(datagram, offset);
        if (byteOrder == ByteOrder.BIG) {
            datagram[o + 7] = (byte)value;
            datagram[o + 6] = (byte)(value >>> 8);
            datagram[o + 5] = (byte)(value >>> 16);
            datagram[o + 4] = (byte)(value >>> 24);
            datagram[o + 3] = (byte)(value >>> 32);
            datagram[o + 2] = (byte)(value >>> 40);
            datagram[o + 1] = (byte)(value >>> 48);
            datagram[o] = (byte)(value >>> 56);
        } else {
            datagram[o] = (byte)value;
            datagram[o + 1] = (byte)(value >>> 8);
            datagram[o + 2] = (byte)(value >>> 16);
            datagram[o + 3] = (byte)(value >>> 24);
            datagram[o + 4] = (byte)(value >>> 32);
            datagram[o + 5] = (byte)(value >>> 40);
            datagram[o + 6] = (byte)(value >>> 48);
            datagram[o + 7] = (byte)(value >>> 56);
        }
    }

    public static void int64Type(ByteBuffer byteBuffer, int offset, ByteOrder byteOrder, @NonNull long value) {
        if (byteOrder == ByteOrder.BIG) {
            byteBuffer.set(offset + 7, (byte)value);
            byteBuffer.set(offset + 6, (byte)(value >>> 8));
            byteBuffer.set(offset + 5, (byte)(value >>> 16));
            byteBuffer.set(offset + 4, (byte)(value >>> 24));
            byteBuffer.set(offset + 3, (byte)(value >>> 32));
            byteBuffer.set(offset + 2, (byte)(value >>> 40));
            byteBuffer.set(offset + 1, (byte)(value >>> 48));
            byteBuffer.set(offset, (byte)(value >>> 56));
        } else {
            byteBuffer.set(offset, (byte)value);
            byteBuffer.set(offset + 1, (byte)(value >>> 8));
            byteBuffer.set(offset + 2, (byte)(value >>> 16));
            byteBuffer.set(offset + 3, (byte)(value >>> 24));
            byteBuffer.set(offset + 4, (byte)(value >>> 32));
            byteBuffer.set(offset + 5, (byte)(value >>> 40));
            byteBuffer.set(offset + 6, (byte)(value >>> 48));
            byteBuffer.set(offset + 7, (byte)(value >>> 56));
        }
    }

    public static void int64Type(@NonNull byte[] datagram, int offset, @NonNull long value) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        CodecUtils.int64Type(datagram, offset, ByteOrder.LITTLE, value);
    }

    public static void type(@NonNull byte[] datagram, int offset, ByteOrder byteOrder, @NonNull long value) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        CodecUtils.int64Type(datagram, offset, byteOrder, value);
    }

    public static float floatType(@NonNull byte[] datagram, int offset, ByteOrder byteOrder) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        int o = CodecUtils.reverse(datagram, offset);
        int value = 0;
        if (byteOrder == ByteOrder.LITTLE) {
            value |= datagram[o] & 0xFF;
            value |= (datagram[o + 1] & 0xFF) << 8;
            value |= (datagram[o + 2] & 0xFF) << 16;
            value |= (datagram[o + 3] & 0xFF) << 24;
        } else if (byteOrder == ByteOrder.BIG) {
            value |= datagram[o + 3] & 0xFF;
            value |= (datagram[o + 2] & 0xFF) << 8;
            value |= (datagram[o + 1] & 0xFF) << 16;
            value |= (datagram[o] & 0xFF) << 24;
        }
        return Float.intBitsToFloat(value);
    }

    public static float floatType(ByteBuffer byteBuffer, int offset, ByteOrder byteOrder) {
        int value = 0;
        if (byteOrder == ByteOrder.LITTLE) {
            value |= byteBuffer.get(offset) & 0xFF;
            value |= (byteBuffer.get(offset + 1) & 0xFF) << 8;
            value |= (byteBuffer.get(offset + 2) & 0xFF) << 16;
            value |= (byteBuffer.get(offset + 3) & 0xFF) << 24;
        } else if (byteOrder == ByteOrder.BIG) {
            value |= (byteBuffer.get(offset) & 0xFF) << 24;
            value |= (byteBuffer.get(offset + 1) & 0xFF) << 16;
            value |= (byteBuffer.get(offset + 2) & 0xFF) << 8;
            value |= byteBuffer.get(offset + 3) & 0xFF;
        }
        return Float.intBitsToFloat(value);
    }

    public static float floatType(@NonNull byte[] datagram, int offset) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        return CodecUtils.floatType(datagram, offset, ByteOrder.LITTLE);
    }

    public static void floatType(@NonNull byte[] datagram, int offset, ByteOrder byteOrder, @NonNull float value) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        int o = CodecUtils.reverse(datagram, offset);
        int bits = Float.floatToIntBits(value);
        if (byteOrder == ByteOrder.LITTLE) {
            datagram[o] = (byte)bits;
            datagram[o + 1] = (byte)(bits >>> 8);
            datagram[o + 2] = (byte)(bits >>> 16);
            datagram[o + 3] = (byte)(bits >>> 24);
        } else if (byteOrder == ByteOrder.BIG) {
            datagram[o + 3] = (byte)bits;
            datagram[o + 2] = (byte)(bits >>> 8);
            datagram[o + 1] = (byte)(bits >>> 16);
            datagram[o] = (byte)(bits >>> 24);
        }
    }

    public static void floatType(ByteBuffer byteBuffer, int offset, ByteOrder byteOrder, @NonNull float value) {
        int bits = Float.floatToIntBits(value);
        if (byteOrder == ByteOrder.LITTLE) {
            byteBuffer.set(offset, (byte)bits);
            byteBuffer.set(offset + 1, (byte)(bits >>> 8));
            byteBuffer.set(offset + 2, (byte)(bits >>> 16));
            byteBuffer.set(offset + 3, (byte)(bits >>> 24));
        } else if (byteOrder == ByteOrder.BIG) {
            byteBuffer.set(offset + 3, (byte)bits);
            byteBuffer.set(offset + 2, (byte)(bits >>> 8));
            byteBuffer.set(offset + 1, (byte)(bits >>> 16));
            byteBuffer.set(offset, (byte)(bits >>> 24));
        }
    }

    public static void floatType(@NonNull byte[] datagram, int offset, @NonNull float value) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        CodecUtils.floatType(datagram, offset, ByteOrder.LITTLE, value);
    }

    public static void type(@NonNull byte[] datagram, int offset, ByteOrder byteOrder, @NonNull float value) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        CodecUtils.floatType(datagram, offset, byteOrder, value);
    }

    public static double doubleType(@NonNull byte[] datagram, int offset, ByteOrder byteOrder) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        int o = CodecUtils.reverse(datagram, offset);
        long value = 0L;
        if (byteOrder == ByteOrder.LITTLE) {
            value |= (long)datagram[o] & 0xFFL;
            value |= ((long)datagram[o + 1] & 0xFFL) << 8;
            value |= ((long)datagram[o + 2] & 0xFFL) << 16;
            value |= ((long)datagram[o + 3] & 0xFFL) << 24;
            value |= ((long)datagram[o + 4] & 0xFFL) << 32;
            value |= ((long)datagram[o + 5] & 0xFFL) << 40;
            value |= ((long)datagram[o + 6] & 0xFFL) << 48;
            value |= ((long)datagram[o + 7] & 0xFFL) << 56;
        } else if (byteOrder == ByteOrder.BIG) {
            value |= (long)datagram[o + 7] & 0xFFL;
            value |= ((long)datagram[o + 6] & 0xFFL) << 8;
            value |= ((long)datagram[o + 5] & 0xFFL) << 16;
            value |= ((long)datagram[o + 4] & 0xFFL) << 24;
            value |= ((long)datagram[o + 3] & 0xFFL) << 32;
            value |= ((long)datagram[o + 2] & 0xFFL) << 40;
            value |= ((long)datagram[o + 1] & 0xFFL) << 48;
            value |= ((long)datagram[o] & 0xFFL) << 56;
        }
        return Double.longBitsToDouble(value);
    }

    public static double doubleType(ByteBuffer byteBuffer, int offset, ByteOrder byteOrder) {
        long value = 0L;
        if (byteOrder == ByteOrder.LITTLE) {
            value |= (long)byteBuffer.get(offset) & 0xFFL;
            value |= ((long)byteBuffer.get(offset + 1) & 0xFFL) << 8;
            value |= ((long)byteBuffer.get(offset + 2) & 0xFFL) << 16;
            value |= ((long)byteBuffer.get(offset + 3) & 0xFFL) << 24;
            value |= ((long)byteBuffer.get(offset + 4) & 0xFFL) << 32;
            value |= ((long)byteBuffer.get(offset + 5) & 0xFFL) << 40;
            value |= ((long)byteBuffer.get(offset + 6) & 0xFFL) << 48;
            value |= ((long)byteBuffer.get(offset + 7) & 0xFFL) << 56;
        } else if (byteOrder == ByteOrder.BIG) {
            value |= ((long)byteBuffer.get(offset) & 0xFFL) << 56;
            value |= ((long)byteBuffer.get(offset + 1) & 0xFFL) << 48;
            value |= ((long)byteBuffer.get(offset + 2) & 0xFFL) << 40;
            value |= ((long)byteBuffer.get(offset + 3) & 0xFFL) << 32;
            value |= ((long)byteBuffer.get(offset + 5) & 0xFFL) << 16;
            value |= ((long)byteBuffer.get(offset + 4) & 0xFFL) << 24;
            value |= ((long)byteBuffer.get(offset + 6) & 0xFFL) << 8;
            value |= (long)byteBuffer.get(offset + 7) & 0xFFL;
        }
        return Double.longBitsToDouble(value);
    }

    public static double doubleType(@NonNull byte[] datagram, int offset) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        return CodecUtils.doubleType(datagram, offset, ByteOrder.LITTLE);
    }

    public static void doubleType(@NonNull byte[] datagram, int offset, ByteOrder byteOrder, @NonNull double value) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        int o = CodecUtils.reverse(datagram, offset);
        long bits = Double.doubleToRawLongBits(value);
        if (byteOrder == ByteOrder.BIG) {
            datagram[o + 7] = (byte)bits;
            datagram[o + 6] = (byte)(bits >>> 8);
            datagram[o + 5] = (byte)(bits >>> 16);
            datagram[o + 4] = (byte)(bits >>> 24);
            datagram[o + 3] = (byte)(bits >>> 32);
            datagram[o + 2] = (byte)(bits >>> 40);
            datagram[o + 1] = (byte)(bits >>> 48);
            datagram[o] = (byte)(bits >>> 56);
        } else {
            datagram[o] = (byte)bits;
            datagram[o + 1] = (byte)(bits >>> 8);
            datagram[o + 2] = (byte)(bits >>> 16);
            datagram[o + 3] = (byte)(bits >>> 24);
            datagram[o + 4] = (byte)(bits >>> 32);
            datagram[o + 5] = (byte)(bits >>> 40);
            datagram[o + 6] = (byte)(bits >>> 48);
            datagram[o + 7] = (byte)(bits >>> 56);
        }
    }

    public static void doubleType(ByteBuffer byteBuffer, int offset, ByteOrder byteOrder, @NonNull double value) {
        long bits = Double.doubleToRawLongBits(value);
        if (byteOrder == ByteOrder.BIG) {
            byteBuffer.set(offset + 7, (byte)bits);
            byteBuffer.set(offset + 6, (byte)(bits >>> 8));
            byteBuffer.set(offset + 5, (byte)(bits >>> 16));
            byteBuffer.set(offset + 4, (byte)(bits >>> 24));
            byteBuffer.set(offset + 3, (byte)(bits >>> 32));
            byteBuffer.set(offset + 2, (byte)(bits >>> 40));
            byteBuffer.set(offset + 1, (byte)(bits >>> 48));
            byteBuffer.set(offset, (byte)(bits >>> 56));
        } else {
            byteBuffer.set(offset, (byte)bits);
            byteBuffer.set(offset + 1, (byte)(bits >>> 8));
            byteBuffer.set(offset + 2, (byte)(bits >>> 16));
            byteBuffer.set(offset + 3, (byte)(bits >>> 24));
            byteBuffer.set(offset + 4, (byte)(bits >>> 32));
            byteBuffer.set(offset + 5, (byte)(bits >>> 40));
            byteBuffer.set(offset + 6, (byte)(bits >>> 48));
            byteBuffer.set(offset + 7, (byte)(bits >>> 56));
        }
    }

    public static void doubleType(@NonNull byte[] datagram, int offset, @NonNull double value) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        CodecUtils.doubleType(datagram, offset, ByteOrder.LITTLE, value);
    }

    public static void type(@NonNull byte[] datagram, int offset, ByteOrder byteOrder, @NonNull double value) {
        if (datagram == null) {
            throw new NullPointerException("datagram is marked non-null but is null");
        }
        CodecUtils.doubleType(datagram, offset, byteOrder, value);
    }
}

