/*
 * Copyright 2019-2021 indunet
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.indunet.fastproto;

import lombok.AllArgsConstructor;
import lombok.Getter;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.exception.CodecException;

import java.util.Arrays;

/**
 * Byte order policy.
 *
 * @author Deng Ran
 * @since 1.0.0
 */
@Getter
@AllArgsConstructor
public enum ByteOrder {
    BIG(0x01, "Big"),
    LITTLE(0x02, "Little");

    int code;
    String name;

    public static ByteOrder byName(String name) {
        return Arrays.stream(ByteOrder.values())
                .filter(p -> p.getName().equals(name))
                .findFirst()
                .orElseThrow(() -> new CodecException(CodecError.INVALID_ENDIAN_POLICY));
    }
}
