/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto;

import java.util.Arrays;
import org.indunet.fastproto.exception.CodecException;

public enum BitOrder {
    LSB_0(1, "LSB_0"),
    MSB_0(2, "MSB_0");

    final int code;
    final String name;

    public static BitOrder byName(String name) {
        return Arrays.stream(BitOrder.values()).filter(p -> p.getName().equals(name)).findFirst().orElseThrow(() -> new CodecException("Invalid bit order, only LSB_0 or MSB_0 can be set."));
    }

    public int getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    private BitOrder(int code, String name) {
        this.code = code;
        this.name = name;
    }
}

