/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto;

import java.util.Arrays;
import org.indunet.fastproto.exception.CodecException;

public final class ByteBuffer {
    byte[] bytes;
    int length;
    int readIndex;
    int writeIndex;
    boolean fixed;

    public ByteBuffer() {
        this.fixed = false;
        this.bytes = new byte[256];
        this.length = 0;
        this.readIndex = 0;
        this.writeIndex = 0;
    }

    public ByteBuffer(int length) {
        this(new byte[length]);
    }

    public ByteBuffer(byte[] bytes) {
        this.fixed = true;
        this.bytes = bytes;
        this.length = bytes.length;
        this.writeIndex = 0;
        this.readIndex = 0;
    }

    public int getWriteIndex() {
        return this.writeIndex;
    }

    public int getReadIndex() {
        return this.readIndex;
    }

    public void resetReadIndex() {
        this.readIndex = 0;
    }

    public void nextReadIndex() {
        ++this.readIndex;
    }

    public void resetWriteIndex() {
        this.writeIndex = 0;
    }

    public void nextWriteIndex() {
        this.expand();
        ++this.writeIndex;
    }

    public void write(byte value) {
        this.expand();
        this.bytes[this.writeIndex++] = value;
    }

    public byte read() {
        return this.get(this.readIndex);
    }

    public void andEq(int offset, byte value) {
        byte tmp = 0;
        if (offset < this.length) {
            tmp = (byte)(this.get(offset) & value);
        }
        this.set(offset, tmp);
    }

    public void orEq(int offset, byte value) {
        byte tmp = value;
        if (offset < this.length) {
            tmp = (byte)(this.get(offset) | value);
        }
        this.set(offset, tmp);
    }

    public void set(int offset, byte value) {
        this.writeIndex = this.reverse(offset);
        this.expand();
        this.bytes[this.writeIndex++] = value;
    }

    private void expand() {
        if (this.writeIndex >= this.length) {
            this.length = this.writeIndex + 1;
        }
        if (this.length == this.bytes.length && !this.fixed) {
            this.bytes = Arrays.copyOf(this.bytes, this.bytes.length * 2);
        }
    }

    public byte get(int offset) {
        this.readIndex = this.reverse(offset);
        if (this.readIndex >= this.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.bytes[this.readIndex++];
    }

    public int reverse(int offset) {
        if (offset >= 0) {
            return offset;
        }
        if (this.fixed) {
            int o = this.bytes.length + offset;
            if (o >= 0) {
                return o;
            }
            throw new IllegalArgumentException(String.format("Illegal offset %d", o));
        }
        throw new CodecException("Reverse addressing is only available with fixed length");
    }

    public int reverse(int offset, int length) {
        if (length > 0) {
            return length;
        }
        if (this.fixed && length < 0) {
            int o = this.reverse(offset);
            int l = this.bytes.length + length - o + 1;
            if (l > 0) {
                return l;
            }
            throw new IllegalArgumentException(String.format("Illegal length %d", l));
        }
        throw new CodecException("Reverse addressing is only available with fixed length");
    }

    public int size() {
        return this.length;
    }

    public byte[] getBytes() {
        return Arrays.copyOf(this.bytes, this.length);
    }
}

