/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto;

import java.util.Arrays;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.exception.CodecException;

public enum ByteOrder {
    BIG(1, "Big"),
    LITTLE(2, "Little");

    int code;
    String name;

    public static ByteOrder byName(String name) {
        return Arrays.stream(ByteOrder.values()).filter(p -> p.getName().equals(name)).findFirst().orElseThrow(() -> new CodecException(CodecError.INVALID_ENDIAN_POLICY));
    }

    public int getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    private ByteOrder(int code, String name) {
        this.code = code;
        this.name = name;
    }
}

