/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import java.util.Collection;
import java.util.stream.IntStream;
import org.indunet.fastproto.ByteBuffer;
import org.indunet.fastproto.annotation.Int8ArrayType;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;
import org.indunet.fastproto.util.CollectionUtils;

public class AsciiArrayCodec
implements Codec<char[]> {
    public char[] decode(byte[] bytes, int offset, int length) {
        try {
            int o = CodecUtils.reverse(bytes, offset);
            int l = CodecUtils.reverse(bytes, offset, length);
            char[] chars = new char[l];
            IntStream.range(0, l).forEach(i -> {
                chars[i] = (char)CodecUtils.int8Type(bytes, o + i);
            });
            return chars;
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new DecodingException("Fail decoding ascii array type.", (Throwable)e);
        }
    }

    public void encode(byte[] bytes, int offset, int length, char[] values) {
        try {
            int o = CodecUtils.reverse(bytes, offset);
            int l = CodecUtils.reverse(bytes, offset, length);
            IntStream.range(0, l).forEach(i -> CodecUtils.int8Type(bytes, o + i, (int)values[i]));
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new EncodingException("Fail encoding ascii array type.", (Throwable)e);
        }
    }

    @Override
    public char[] decode(CodecContext context, byte[] bytes) {
        Int8ArrayType type = context.getDataTypeAnnotation(Int8ArrayType.class);
        return this.decode(bytes, type.offset(), type.length());
    }

    @Override
    public void encode(CodecContext context, ByteBuffer buffer, char[] values) {
        Int8ArrayType type = context.getDataTypeAnnotation(Int8ArrayType.class);
        try {
            int l = buffer.reverse(type.offset(), type.length());
            IntStream.range(0, l).forEach(i -> CodecUtils.int8Type(buffer, type.offset() + i, (int)values[i]));
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new EncodingException("Fail encoding ascii array type.", (Throwable)e);
        }
    }

    public class CollectionCodec
    implements Codec<Collection<Character>> {
        @Override
        public Collection<Character> decode(CodecContext context, byte[] bytes) {
            try {
                Class<?> type = context.getFieldType();
                Collection collection = CollectionUtils.newInstance(type);
                for (char c : AsciiArrayCodec.this.decode(context, bytes)) {
                    collection.add(Character.valueOf(c));
                }
                return collection;
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new DecodingException(String.format("Fail decoding collection type of %s", context.getFieldType().toString()), (Throwable)e);
            }
        }

        @Override
        public void encode(CodecContext context, ByteBuffer buffer, Collection<Character> collection) {
            char[] chars = new char[collection.size()];
            Character[] values = (Character[])collection.stream().toArray(Character[]::new);
            IntStream.range(0, chars.length).forEach(i -> {
                chars[i] = values[i].charValue();
            });
            AsciiArrayCodec.this.encode(context, buffer, chars);
        }
    }

    public class WrapperCodec
    implements Codec<Character[]> {
        @Override
        public Character[] decode(CodecContext context, byte[] bytes) {
            char[] chars = AsciiArrayCodec.this.decode(context, bytes);
            return (Character[])IntStream.range(0, chars.length).mapToObj(i -> Character.valueOf(chars[i])).toArray(Character[]::new);
        }

        @Override
        public void encode(CodecContext context, ByteBuffer buffer, Character[] values) {
            char[] chars = new char[values.length];
            IntStream.range(0, values.length).forEach(i -> {
                chars[i] = values[i].charValue();
            });
            AsciiArrayCodec.this.encode(context, buffer, chars);
        }
    }
}

