/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import org.indunet.fastproto.ByteBuffer;
import org.indunet.fastproto.annotation.AsciiType;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;

public class AsciiCodec
implements Codec<Character> {
    public Character decode(byte[] datagram, int offset) {
        try {
            int num = CodecUtils.uint8Type(datagram, offset);
            if (num > 127) {
                throw new DecodingException(String.format("%d is not valid ascii.", num));
            }
            return Character.valueOf((char)num);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DecodingException("Fail decoding ascii type.", (Throwable)e);
        }
    }

    public void encode(byte[] datagram, int offset, char value) {
        try {
            if (value > '\u007f') {
                throw new EncodingException(String.format("%c is not valid ascii.", Character.valueOf(value)));
            }
            CodecUtils.uint8Type(datagram, offset, (int)value);
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new EncodingException("Fail encoding ascii type.", (Throwable)e);
        }
    }

    @Override
    public Character decode(CodecContext context, byte[] bytes) {
        AsciiType type = context.getDataTypeAnnotation(AsciiType.class);
        return this.decode(bytes, type.offset());
    }

    @Override
    public void encode(CodecContext context, ByteBuffer buffer, Character value) {
        AsciiType type = context.getDataTypeAnnotation(AsciiType.class);
        try {
            char num = value.charValue();
            if (num > '\u007f') {
                throw new EncodingException(String.format("%c is not valid ascii.", value));
            }
            CodecUtils.uint8Type(buffer, type.offset(), (int)value.charValue());
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new EncodingException("Fail encoding ascii type.", (Throwable)e);
        }
    }
}

