/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import java.util.Collection;
import java.util.stream.IntStream;
import org.indunet.fastproto.ByteBuffer;
import org.indunet.fastproto.annotation.BinaryType;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;
import org.indunet.fastproto.util.CollectionUtils;

public class BinaryCodec
implements Codec<byte[]> {
    public byte[] decode(byte[] bytes, int offset, int length) {
        try {
            return CodecUtils.binaryType(bytes, offset, length);
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new DecodingException("Fail decoding binary type.", (Throwable)e);
        }
    }

    public void encode(byte[] bytes, int offset, int length, byte[] values) {
        try {
            CodecUtils.binaryType(bytes, offset, length, values);
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new EncodingException("Fail encoding binary type.", (Throwable)e);
        }
    }

    @Override
    public byte[] decode(CodecContext context, byte[] bytes) {
        BinaryType type = context.getDataTypeAnnotation(BinaryType.class);
        return this.decode(bytes, type.offset(), type.length());
    }

    @Override
    public void encode(CodecContext context, ByteBuffer buffer, byte[] values) {
        BinaryType type = context.getDataTypeAnnotation(BinaryType.class);
        try {
            CodecUtils.binaryType(buffer, type.offset(), type.length(), values);
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new EncodingException("Fail encoding binary type.", (Throwable)e);
        }
    }

    public class CollectionCodec
    implements Codec<Collection<Byte>> {
        @Override
        public Collection<Byte> decode(CodecContext context, byte[] bytes) {
            try {
                Class<?> type = context.getFieldType();
                Collection collection = CollectionUtils.newInstance(type);
                for (byte b : BinaryCodec.this.decode(context, bytes)) {
                    collection.add(b);
                }
                return collection;
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new DecodingException(String.format("Fail decoding collection type of %s", context.getFieldType().toString()), (Throwable)e);
            }
        }

        @Override
        public void encode(CodecContext context, ByteBuffer buffer, Collection<Byte> collection) {
            byte[] bs = new byte[collection.size()];
            Byte[] values = (Byte[])collection.stream().toArray(Byte[]::new);
            IntStream.range(0, bs.length).forEach(i -> {
                bs[i] = values[i];
            });
            BinaryCodec.this.encode(context, buffer, bs);
        }
    }

    public class WrapperCodec
    implements Codec<Byte[]> {
        @Override
        public Byte[] decode(CodecContext context, byte[] bytes) {
            byte[] bs = BinaryCodec.this.decode(context, bytes);
            Byte[] values = new Byte[bs.length];
            IntStream.range(0, bs.length).forEach(i -> {
                values[i] = bs[i];
            });
            return values;
        }

        @Override
        public void encode(CodecContext context, ByteBuffer buffer, Byte[] values) {
            byte[] bs = new byte[values.length];
            IntStream.range(0, bs.length).forEach(i -> {
                bs[i] = values[i];
            });
            BinaryCodec.this.encode(context, buffer, bs);
        }
    }
}

