/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import org.indunet.fastproto.BitOrder;
import org.indunet.fastproto.ByteBuffer;
import org.indunet.fastproto.annotation.BoolType;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;

public class BoolCodec
implements Codec<Boolean> {
    @Override
    public Boolean decode(CodecContext context, byte[] bytes) {
        BoolType type = context.getDataTypeAnnotation(BoolType.class);
        BitOrder order = context.getBitOrder(type::bitOrder);
        try {
            return CodecUtils.boolType(bytes, type.byteOffset(), type.bitOffset(), order);
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new DecodingException("Fail decoding boolean type.", (Throwable)e);
        }
    }

    @Override
    public void encode(CodecContext context, ByteBuffer buffer, Boolean value) {
        BoolType type = context.getDataTypeAnnotation(BoolType.class);
        BitOrder bitOrder = context.getBitOrder(type::bitOrder);
        try {
            CodecUtils.boolType(buffer, type.byteOffset(), type.bitOffset(), bitOrder, (boolean)value);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            throw new EncodingException("Fail encoding the boolean type.", (Throwable)e);
        }
    }
}

