/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import org.indunet.fastproto.ByteBuffer;
import org.indunet.fastproto.annotation.Int8Type;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;

public class ByteCodec
implements Codec<Byte> {
    @Override
    public Byte decode(CodecContext context, byte[] bytes) {
        Int8Type type = context.getDataTypeAnnotation(Int8Type.class);
        try {
            return CodecUtils.byteType(bytes, type.offset());
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new DecodingException("Fail decoding int8(byte) type.", (Throwable)e);
        }
    }

    @Override
    public void encode(CodecContext context, ByteBuffer buffer, Byte value) {
        Int8Type type = context.getDataTypeAnnotation(Int8Type.class);
        try {
            CodecUtils.byteType(buffer, type.offset(), (byte)value);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            throw new EncodingException("Fail encoding int8(byte) type.", (Throwable)e);
        }
    }
}

