/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import java.util.Calendar;
import org.indunet.fastproto.ByteBuffer;
import org.indunet.fastproto.ByteOrder;
import org.indunet.fastproto.annotation.TimeType;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;

public class CalendarCodec
implements Codec<Calendar> {
    public Calendar decode(byte[] bytes, int offset, ByteOrder policy) {
        try {
            long millis = CodecUtils.int64Type(bytes, offset, policy);
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(millis);
            return calendar;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DecodingException("Fail decoding time(calendar) type.", (Throwable)e);
        }
    }

    public void encode(byte[] bytes, int offset, ByteOrder byteOrder, Calendar calendar) {
        try {
            long millis = calendar.getTimeInMillis();
            CodecUtils.int64Type(bytes, offset, byteOrder, millis);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new EncodingException("Fail encoding time(calendar) type.", (Throwable)e);
        }
    }

    @Override
    public Calendar decode(CodecContext context, byte[] bytes) {
        TimeType type = context.getDataTypeAnnotation(TimeType.class);
        ByteOrder order = context.getByteOrder(type::byteOrder);
        return this.decode(bytes, type.offset(), order);
    }

    @Override
    public void encode(CodecContext context, ByteBuffer buffer, Calendar calendar) {
        TimeType type = context.getDataTypeAnnotation(TimeType.class);
        ByteOrder order = context.getByteOrder(type::byteOrder);
        try {
            long millis = calendar.getTimeInMillis();
            CodecUtils.int64Type(buffer, type.offset(), order, millis);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new EncodingException("Fail encoding time(calendar) type.", (Throwable)e);
        }
    }
}

