/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import java.util.Collection;
import java.util.stream.IntStream;
import org.indunet.fastproto.ByteBuffer;
import org.indunet.fastproto.ByteOrder;
import org.indunet.fastproto.annotation.UInt16ArrayType;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;
import org.indunet.fastproto.util.CollectionUtils;

public class CharArrayCodec
implements Codec<char[]> {
    public char[] decode(byte[] bytes, int offset, int length, ByteOrder byteOrder) {
        try {
            int o = CodecUtils.reverse(bytes, offset);
            int l = length;
            if (l < 0) {
                l = CodecUtils.reverse(bytes, offset, length * 2) / 2 + 1;
            }
            char[] chars = new char[l];
            IntStream.range(0, l).forEach(i -> {
                chars[i] = (char)CodecUtils.uint16Type(bytes, o + i * 2, byteOrder);
            });
            return chars;
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new DecodingException("Fail decoding char array type.", (Throwable)e);
        }
    }

    public void encode(byte[] bytes, int offset, int length, ByteOrder policy, char[] values) {
        try {
            int o = CodecUtils.reverse(bytes, offset);
            int l = length;
            if (l < 0) {
                l = CodecUtils.reverse(bytes, offset, length * 2) / 2 + 1;
            }
            IntStream.range(0, l).forEach(i -> CodecUtils.uint16Type(bytes, o + i * 2, policy, (int)values[i]));
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new EncodingException("Fail encoding char array type.", (Throwable)e);
        }
    }

    @Override
    public char[] decode(CodecContext context, byte[] bytes) {
        UInt16ArrayType type = context.getDataTypeAnnotation(UInt16ArrayType.class);
        ByteOrder order = context.getByteOrder(type::byteOrder);
        return this.decode(bytes, type.offset(), type.length(), order);
    }

    @Override
    public void encode(CodecContext context, ByteBuffer buffer, char[] values) {
        UInt16ArrayType type = context.getDataTypeAnnotation(UInt16ArrayType.class);
        ByteOrder order = context.getByteOrder(type::byteOrder);
        try {
            int l = type.length();
            if (l < 0) {
                l = buffer.reverse(type.offset(), type.length() * 2) / 2 + 1;
            }
            IntStream.range(0, l).forEach(i -> CodecUtils.uint16Type(buffer, type.offset() + i * 2, order, (int)values[i]));
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new EncodingException("Fail encoding char array type.", (Throwable)e);
        }
    }

    public class CollectionCodec
    implements Codec<Collection<Character>> {
        @Override
        public Collection<Character> decode(CodecContext context, byte[] bytes) {
            try {
                Class<?> type = context.getFieldType();
                Collection collection = CollectionUtils.newInstance(type);
                for (char c : CharArrayCodec.this.decode(context, bytes)) {
                    collection.add(Character.valueOf(c));
                }
                return collection;
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new DecodingException(String.format("Fail decoding collection type of %s", context.getFieldType().toString()), (Throwable)e);
            }
        }

        @Override
        public void encode(CodecContext context, ByteBuffer buffer, Collection<Character> collection) {
            char[] chars = new char[collection.size()];
            Character[] values = (Character[])collection.stream().toArray(Character[]::new);
            IntStream.range(0, chars.length).forEach(i -> {
                chars[i] = values[i].charValue();
            });
            CharArrayCodec.this.encode(context, buffer, chars);
        }
    }

    public class WrapperCodec
    implements Codec<Character[]> {
        @Override
        public Character[] decode(CodecContext context, byte[] bytes) {
            char[] chars = CharArrayCodec.this.decode(context, bytes);
            return (Character[])IntStream.range(0, chars.length).mapToObj(i -> Character.valueOf(chars[i])).toArray(Character[]::new);
        }

        @Override
        public void encode(CodecContext context, ByteBuffer buffer, Character[] values) {
            char[] chars = new char[values.length];
            IntStream.range(0, values.length).forEach(i -> {
                chars[i] = values[i].charValue();
            });
            CharArrayCodec.this.encode(context, buffer, chars);
        }
    }
}

