/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import org.indunet.fastproto.ByteBuffer;
import org.indunet.fastproto.ByteOrder;
import org.indunet.fastproto.annotation.CharType;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;

public class CharCodec
implements Codec<Character> {
    public Character decode(byte[] datagram, int offset, ByteOrder byteOrder) {
        try {
            return Character.valueOf((char)CodecUtils.uint16Type(datagram, offset, byteOrder));
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DecodingException("Fail decoding char type.", (Throwable)e);
        }
    }

    public void encode(byte[] datagram, int offset, ByteOrder byteOrder, char value) {
        try {
            CodecUtils.uint16Type(datagram, offset, byteOrder, (int)value);
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new EncodingException("Fail encoding char type.", (Throwable)e);
        }
    }

    @Override
    public Character decode(CodecContext context, byte[] bytes) {
        CharType type = context.getDataTypeAnnotation(CharType.class);
        ByteOrder order = context.getByteOrder(type::byteOrder);
        return this.decode(bytes, type.offset(), order);
    }

    @Override
    public void encode(CodecContext context, ByteBuffer buffer, Character value) {
        CharType type = context.getDataTypeAnnotation(CharType.class);
        ByteOrder order = context.getByteOrder(type::byteOrder);
        try {
            CodecUtils.uint16Type(buffer, type.offset(), order, (int)value.charValue());
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new EncodingException("Fail encoding char type.", (Throwable)e);
        }
    }
}

