/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import java.text.MessageFormat;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.indunet.fastproto.ByteBuffer;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.CodecError;
import org.indunet.fastproto.exception.CodecException;

public interface Codec<T> {
    public static final ConcurrentHashMap<Class<? extends Codec>, Codec> codecs = new ConcurrentHashMap();
    public static final ConcurrentHashMap<Class<? extends Function>, Function> formulas = new ConcurrentHashMap();

    public static Codec getCodec(Class<? extends Codec> clazz) {
        return codecs.computeIfAbsent(clazz, __ -> {
            try {
                return (Codec)clazz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
                throw new CodecException(MessageFormat.format(CodecError.FAIL_INIT_CODEC.getMessage(), clazz.getName()), (Throwable)e);
            }
        });
    }

    public static Function getFormula(Class<? extends Function> clazz) {
        return formulas.computeIfAbsent(clazz, __ -> {
            try {
                return (Function)clazz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
                throw new CodecException(MessageFormat.format(CodecError.FAIL_INIT_FORMULA.getMessage(), clazz.getName()), (Throwable)e);
            }
        });
    }

    public T decode(CodecContext var1, byte[] var2);

    public void encode(CodecContext var1, ByteBuffer var2, T var3);
}

