/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import java.util.Date;
import org.indunet.fastproto.ByteBuffer;
import org.indunet.fastproto.ByteOrder;
import org.indunet.fastproto.annotation.TimeType;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;

public class DateCodec
implements Codec<Date> {
    public Date decode(byte[] bytes, int offset, ByteOrder byteOrder) {
        try {
            long millis = CodecUtils.int64Type(bytes, offset, byteOrder);
            return new Date(millis);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DecodingException("Fail decoding time(date) type.", (Throwable)e);
        }
    }

    public void encode(byte[] bytes, int offset, ByteOrder policy, Date value) {
        try {
            long millis = value.getTime();
            CodecUtils.int64Type(bytes, offset, policy, millis);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new EncodingException("Fail encoding time(date) type.", (Throwable)e);
        }
    }

    @Override
    public Date decode(CodecContext context, byte[] bytes) {
        TimeType type = context.getDataTypeAnnotation(TimeType.class);
        ByteOrder order = context.getByteOrder(type::byteOrder);
        return this.decode(bytes, type.offset(), order);
    }

    @Override
    public void encode(CodecContext context, ByteBuffer buffer, Date value) {
        TimeType type = context.getDataTypeAnnotation(TimeType.class);
        ByteOrder order = context.getByteOrder(type::byteOrder);
        try {
            long millis = value.getTime();
            CodecUtils.int64Type(buffer, type.offset(), order, millis);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new EncodingException("Fail encoding time(date) type.", (Throwable)e);
        }
    }
}

