/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import java.util.Arrays;
import java.util.Collection;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.indunet.fastproto.ByteBuffer;
import org.indunet.fastproto.ByteOrder;
import org.indunet.fastproto.annotation.DoubleArrayType;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;
import org.indunet.fastproto.util.CollectionUtils;

public class DoubleArrayCodec
implements Codec<double[]> {
    public double[] decode(byte[] bytes, int offset, int length, ByteOrder byteOrder) {
        try {
            int o = CodecUtils.reverse(bytes, offset);
            int l = length;
            if (l < 0) {
                l = CodecUtils.reverse(bytes, offset, length * 8) / 8 + 1;
            }
            return IntStream.range(0, l).mapToDouble(i -> CodecUtils.doubleType(bytes, o + i * 8, byteOrder)).toArray();
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new DecodingException("Fail decoding double array type.", (Throwable)e);
        }
    }

    public void encode(byte[] bytes, int offset, int length, ByteOrder byteOrder, double[] values) {
        try {
            int l = length;
            if (l < 0) {
                l = CodecUtils.reverse(bytes, offset, length * 8) / 8 + 1;
            }
            if (l >= values.length) {
                IntStream.range(0, values.length).forEach(i -> CodecUtils.doubleType(bytes, offset + i * 8, byteOrder, values[i]));
            } else {
                IntStream.range(0, l).forEach(i -> CodecUtils.doubleType(bytes, offset + i * 8, byteOrder, values[i]));
            }
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new EncodingException("Fail encoding double array type.", (Throwable)e);
        }
    }

    @Override
    public double[] decode(CodecContext context, byte[] bytes) {
        DoubleArrayType type = context.getDataTypeAnnotation(DoubleArrayType.class);
        ByteOrder order = context.getByteOrder(type::byteOrder);
        return this.decode(bytes, type.offset(), type.length(), order);
    }

    @Override
    public void encode(CodecContext context, ByteBuffer buffer, double[] values) {
        DoubleArrayType type = context.getDataTypeAnnotation(DoubleArrayType.class);
        ByteOrder order = context.getByteOrder(type::byteOrder);
        try {
            int l = type.length();
            if (l < 0) {
                l = buffer.reverse(type.offset(), type.length() * 8) / 8 + 1;
            }
            if (l >= values.length) {
                IntStream.range(0, values.length).forEach(i -> CodecUtils.doubleType(buffer, type.offset() + i * 8, order, values[i]));
            } else {
                IntStream.range(0, l).forEach(i -> CodecUtils.doubleType(buffer, type.offset() + i * 8, order, values[i]));
            }
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new EncodingException("Fail encoding double array type.", (Throwable)e);
        }
    }

    public class CollectionCodec
    implements Codec<Collection<Double>> {
        @Override
        public Collection<Double> decode(CodecContext context, byte[] bytes) {
            try {
                Class<?> type = context.getFieldType();
                Collection collection = CollectionUtils.newInstance(type);
                Arrays.stream(DoubleArrayCodec.this.decode(context, bytes)).forEach(collection::add);
                return collection;
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new DecodingException(String.format("Fail decoding collection type of %s", context.getFieldType().toString()), (Throwable)e);
            }
        }

        @Override
        public void encode(CodecContext context, ByteBuffer buffer, Collection<Double> collection) {
            double[] doubles = collection.stream().mapToDouble(Double::doubleValue).toArray();
            DoubleArrayCodec.this.encode(context, buffer, doubles);
        }
    }

    public class WrapperCodec
    implements Codec<Double[]> {
        @Override
        public Double[] decode(CodecContext context, byte[] bytes) {
            return (Double[])DoubleStream.of(DoubleArrayCodec.this.decode(context, bytes)).mapToObj(Double::valueOf).toArray(Double[]::new);
        }

        @Override
        public void encode(CodecContext context, ByteBuffer buffer, Double[] values) {
            double[] doubles = Stream.of(values).mapToDouble(i -> i).toArray();
            DoubleArrayCodec.this.encode(context, buffer, doubles);
        }
    }
}

