/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import org.indunet.fastproto.ByteBuffer;
import org.indunet.fastproto.ByteOrder;
import org.indunet.fastproto.annotation.DoubleType;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;

public class DoubleCodec
implements Codec<Double> {
    @Override
    public Double decode(CodecContext context, byte[] bytes) {
        DoubleType type = context.getDataTypeAnnotation(DoubleType.class);
        ByteOrder order = context.getByteOrder(type::byteOrder);
        try {
            return CodecUtils.doubleType(bytes, type.offset(), order);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DecodingException("Fail decoding double type.", (Throwable)e);
        }
    }

    @Override
    public void encode(CodecContext context, ByteBuffer buffer, Double value) {
        DoubleType type = context.getDataTypeAnnotation(DoubleType.class);
        ByteOrder order = context.getByteOrder(type::byteOrder);
        try {
            CodecUtils.doubleType(buffer, type.offset(), order, (double)value);
        }
        catch (IndexOutOfBoundsException e) {
            throw new EncodingException("Fail encoding double type.", (Throwable)e);
        }
    }
}

