/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import org.indunet.fastproto.ByteBuffer;
import org.indunet.fastproto.ByteOrder;
import org.indunet.fastproto.annotation.FloatType;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;

public class FloatCodec
implements Codec<Float> {
    @Override
    public Float decode(CodecContext context, byte[] bytes) {
        FloatType type = context.getDataTypeAnnotation(FloatType.class);
        ByteOrder order = context.getByteOrder(type::byteOrder);
        try {
            return Float.valueOf(CodecUtils.floatType(bytes, type.offset(), order));
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DecodingException("Fail decoding float type.", (Throwable)e);
        }
    }

    @Override
    public void encode(CodecContext context, ByteBuffer buffer, Float value) {
        FloatType type = context.getDataTypeAnnotation(FloatType.class);
        ByteOrder order = context.getByteOrder(type::byteOrder);
        try {
            CodecUtils.floatType(buffer, type.offset(), order, value.floatValue());
        }
        catch (IndexOutOfBoundsException e) {
            throw new EncodingException("Fail encoding float type.", (Throwable)e);
        }
    }
}

