/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import java.time.Instant;
import org.indunet.fastproto.ByteBuffer;
import org.indunet.fastproto.ByteOrder;
import org.indunet.fastproto.annotation.TimeType;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;

public class InstantCodec
implements Codec<Instant> {
    public Instant decode(byte[] bytes, int offset, ByteOrder policy) {
        try {
            long millis = CodecUtils.int64Type(bytes, offset, policy);
            return Instant.ofEpochMilli(millis);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DecodingException("Fail decoding time(Instant) type.", (Throwable)e);
        }
    }

    public void encode(byte[] bytes, int offset, ByteOrder policy, Instant value) {
        try {
            long millis = value.toEpochMilli();
            CodecUtils.int64Type(bytes, offset, policy, millis);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new EncodingException("Fail encoding time(Instant) type.", (Throwable)e);
        }
    }

    @Override
    public Instant decode(CodecContext context, byte[] bytes) {
        TimeType type = context.getDataTypeAnnotation(TimeType.class);
        ByteOrder order = context.getByteOrder(type::byteOrder);
        return this.decode(bytes, type.offset(), order);
    }

    @Override
    public void encode(CodecContext context, ByteBuffer buffer, Instant value) {
        TimeType type = context.getDataTypeAnnotation(TimeType.class);
        ByteOrder order = context.getByteOrder(type::byteOrder);
        try {
            long millis = value.toEpochMilli();
            CodecUtils.int64Type(buffer, type.offset(), order, millis);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new EncodingException("Fail encoding time(Instant) type.", (Throwable)e);
        }
    }
}

