/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import org.indunet.fastproto.ByteBuffer;
import org.indunet.fastproto.ByteOrder;
import org.indunet.fastproto.annotation.Int16Type;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;

public class Int16Codec
implements Codec<Integer> {
    @Override
    public Integer decode(CodecContext context, byte[] bytes) {
        Int16Type type = context.getDataTypeAnnotation(Int16Type.class);
        ByteOrder order = context.getByteOrder(type::byteOrder);
        try {
            return CodecUtils.int16Type(bytes, type.offset(), order);
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new DecodingException("Fail decoding int16(int) type.", (Throwable)e);
        }
    }

    @Override
    public void encode(CodecContext context, ByteBuffer buffer, Integer value) {
        Int16Type type = context.getDataTypeAnnotation(Int16Type.class);
        ByteOrder order = context.getByteOrder(type::byteOrder);
        try {
            CodecUtils.int16Type(buffer, type.offset(), order, (int)value);
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new EncodingException("Fail encoding int16(int) type.", (Throwable)e);
        }
    }
}

