/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import java.util.Arrays;
import java.util.Collection;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.indunet.fastproto.ByteBuffer;
import org.indunet.fastproto.ByteOrder;
import org.indunet.fastproto.annotation.Int32ArrayType;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;
import org.indunet.fastproto.util.CollectionUtils;

public class Int32ArrayCodec
implements Codec<int[]> {
    public int[] decode(byte[] bytes, int offset, int length, ByteOrder policy) {
        try {
            int o = CodecUtils.reverse(bytes, offset);
            int l = length;
            if (l < 0) {
                l = CodecUtils.reverse(bytes, offset, length * 4) / 4 + 1;
            }
            return IntStream.range(0, l).map(i -> CodecUtils.int32Type(bytes, o + i * 4, policy)).toArray();
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new DecodingException("Fail decoding int32 array type.", (Throwable)e);
        }
    }

    public void encode(byte[] bytes, int offset, int length, ByteOrder policy, int[] values) {
        try {
            int o = CodecUtils.reverse(bytes, offset);
            int l = length;
            if (l < 0) {
                l = CodecUtils.reverse(bytes, offset, length * 4) / 4 + 1;
            }
            IntStream.range(0, l).forEach(i -> CodecUtils.int32Type(bytes, o + i * 4, policy, values[i]));
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new EncodingException("Fail encoding int32 array type.", (Throwable)e);
        }
    }

    @Override
    public int[] decode(CodecContext context, byte[] bytes) {
        Int32ArrayType type = context.getDataTypeAnnotation(Int32ArrayType.class);
        ByteOrder order = context.getByteOrder(type::byteOrder);
        return this.decode(bytes, type.offset(), type.length(), order);
    }

    @Override
    public void encode(CodecContext context, ByteBuffer buffer, int[] values) {
        Int32ArrayType type = context.getDataTypeAnnotation(Int32ArrayType.class);
        ByteOrder order = context.getByteOrder(type::byteOrder);
        try {
            int l = type.length();
            if (l < 0) {
                l = buffer.reverse(type.offset(), type.length() * 4) / 4 + 1;
            }
            IntStream.range(0, l).forEach(i -> CodecUtils.int32Type(buffer, type.offset() + i * 4, order, values[i]));
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new EncodingException("Fail encoding int32 array type.", (Throwable)e);
        }
    }

    public class CollectionCodec
    implements Codec<Collection<Integer>> {
        @Override
        public Collection<Integer> decode(CodecContext context, byte[] bytes) {
            try {
                Class<?> type = context.getFieldType();
                Collection collection = CollectionUtils.newInstance(type);
                Arrays.stream(Int32ArrayCodec.this.decode(context, bytes)).forEach(collection::add);
                return collection;
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new DecodingException(String.format("Fail decoding collection type of %s", context.getFieldType().toString()), (Throwable)e);
            }
        }

        @Override
        public void encode(CodecContext context, ByteBuffer buffer, Collection<Integer> collection) {
            Int32ArrayCodec.this.encode(context, buffer, collection.stream().mapToInt(Integer::intValue).toArray());
        }
    }

    public class WrapperCodec
    implements Codec<Integer[]> {
        @Override
        public Integer[] decode(CodecContext context, byte[] bytes) {
            return (Integer[])IntStream.of(Int32ArrayCodec.this.decode(context, bytes)).mapToObj(Integer::valueOf).toArray(Integer[]::new);
        }

        @Override
        public void encode(CodecContext context, ByteBuffer buffer, Integer[] values) {
            int[] ints = Stream.of(values).mapToInt(i -> i).toArray();
            Int32ArrayCodec.this.encode(context, buffer, ints);
        }
    }
}

