/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import org.indunet.fastproto.ByteBuffer;
import org.indunet.fastproto.ByteOrder;
import org.indunet.fastproto.annotation.Int32Type;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;

public class Int32Codec
implements Codec<Integer> {
    @Override
    public Integer decode(CodecContext context, byte[] bytes) {
        Int32Type type = context.getDataTypeAnnotation(Int32Type.class);
        ByteOrder order = context.getByteOrder(type::byteOrder);
        try {
            return CodecUtils.int32Type(bytes, type.offset(), order);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DecodingException("Fail decoding int32 type.", (Throwable)e);
        }
    }

    @Override
    public void encode(CodecContext context, ByteBuffer buffer, Integer value) {
        Int32Type type = context.getDataTypeAnnotation(Int32Type.class);
        ByteOrder order = context.getByteOrder(type::byteOrder);
        try {
            CodecUtils.int32Type(buffer, type.offset(), order, (int)value);
        }
        catch (IndexOutOfBoundsException e) {
            throw new EncodingException("Fail encoding int32 type.", (Throwable)e);
        }
    }
}

