/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import org.indunet.fastproto.ByteBuffer;
import org.indunet.fastproto.ByteOrder;
import org.indunet.fastproto.annotation.Int64Type;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;

public class Int64Codec
implements Codec<Long> {
    @Override
    public Long decode(CodecContext context, byte[] bytes) {
        Int64Type type = context.getDataTypeAnnotation(Int64Type.class);
        ByteOrder order = context.getByteOrder(type::byteOrder);
        try {
            return CodecUtils.int64Type(bytes, type.offset(), order);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DecodingException("Fail decoding int64 type.", (Throwable)e);
        }
    }

    @Override
    public void encode(CodecContext context, ByteBuffer buffer, Long value) {
        Int64Type type = context.getDataTypeAnnotation(Int64Type.class);
        ByteOrder order = context.getByteOrder(type::byteOrder);
        try {
            CodecUtils.int64Type(buffer, type.offset(), order, (long)value);
        }
        catch (IndexOutOfBoundsException e) {
            throw new EncodingException("Fail encoding int64 type.", (Throwable)e);
        }
    }
}

