/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import org.indunet.fastproto.ByteBuffer;
import org.indunet.fastproto.annotation.Int8Type;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;

public class Int8Codec
implements Codec<Integer> {
    @Override
    public Integer decode(CodecContext context, byte[] bytes) {
        Int8Type type = context.getDataTypeAnnotation(Int8Type.class);
        try {
            return CodecUtils.int8Type(bytes, type.offset());
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new DecodingException("Fail decoding int8(int) type.", (Throwable)e);
        }
    }

    @Override
    public void encode(CodecContext context, ByteBuffer buffer, Integer value) {
        Int8Type type = context.getDataTypeAnnotation(Int8Type.class);
        try {
            CodecUtils.int8Type(buffer, type.offset(), (int)value);
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new EncodingException("Fail encoding int8(int) type.", (Throwable)e);
        }
    }
}

