/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import org.indunet.fastproto.ByteBuffer;
import org.indunet.fastproto.ByteOrder;
import org.indunet.fastproto.annotation.TimeType;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;

public class LocalDateTimeCodec
implements Codec<LocalDateTime> {
    public LocalDateTime decode(byte[] bytes, int offset, ByteOrder byteOrder) {
        try {
            long millis = CodecUtils.int64Type(bytes, offset, byteOrder);
            Instant instant = Instant.ofEpochMilli(millis);
            return LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DecodingException("Fail decoding time(LocalDateTime) type.", (Throwable)e);
        }
    }

    public void encode(byte[] bytes, int offset, ByteOrder byteOrder, LocalDateTime value) {
        try {
            ZoneOffset zoneOffset = ZoneId.systemDefault().getRules().getOffset(Instant.now());
            long millis = value.toInstant(zoneOffset).toEpochMilli();
            CodecUtils.int64Type(bytes, offset, byteOrder, millis);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new EncodingException("Fail encoding time(LocalDateTime) type.", (Throwable)e);
        }
    }

    @Override
    public LocalDateTime decode(CodecContext context, byte[] bytes) {
        TimeType type = context.getDataTypeAnnotation(TimeType.class);
        ByteOrder order = context.getByteOrder(type::byteOrder);
        return this.decode(bytes, type.offset(), order);
    }

    @Override
    public void encode(CodecContext context, ByteBuffer buffer, LocalDateTime value) {
        TimeType type = context.getDataTypeAnnotation(TimeType.class);
        ByteOrder order = context.getByteOrder(type::byteOrder);
        try {
            ZoneOffset zoneOffset = ZoneId.systemDefault().getRules().getOffset(Instant.now());
            long millis = value.toInstant(zoneOffset).toEpochMilli();
            CodecUtils.int64Type(buffer, type.offset(), order, millis);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new EncodingException("Fail encoding time(LocalDateTime) type.", (Throwable)e);
        }
    }
}

