/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import org.indunet.fastproto.ByteBuffer;
import org.indunet.fastproto.ByteOrder;
import org.indunet.fastproto.annotation.Int16Type;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;

public class ShortCodec
implements Codec<Short> {
    @Override
    public Short decode(CodecContext context, byte[] bytes) {
        Int16Type type = context.getDataTypeAnnotation(Int16Type.class);
        ByteOrder order = context.getByteOrder(type::byteOrder);
        try {
            return CodecUtils.shortType(bytes, type.offset(), order);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DecodingException("Fail decoding int16(short) type.", (Throwable)e);
        }
    }

    @Override
    public void encode(CodecContext context, ByteBuffer buffer, Short value) {
        Int16Type type = context.getDataTypeAnnotation(Int16Type.class);
        ByteOrder order = context.getByteOrder(type::byteOrder);
        try {
            CodecUtils.shortType(buffer, type.offset(), order, (short)value);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new EncodingException("Fail encoding int16(short) type.", (Throwable)e);
        }
    }
}

