/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import java.sql.Timestamp;
import org.indunet.fastproto.ByteBuffer;
import org.indunet.fastproto.ByteOrder;
import org.indunet.fastproto.annotation.TimeType;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;

public class TimestampCodec
implements Codec<Timestamp> {
    public Timestamp decode(byte[] datagram, int offset, ByteOrder byteOrder) {
        try {
            long millis = CodecUtils.int64Type(datagram, offset, byteOrder);
            return new Timestamp(millis);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DecodingException("Fail decoding time(timestamp) type.", (Throwable)e);
        }
    }

    public void encode(byte[] datagram, int offset, ByteOrder byteOrder, Timestamp value) {
        try {
            CodecUtils.int64Type(datagram, offset, byteOrder, value.getTime());
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new EncodingException("Fail encoding times(timestamp) type.", (Throwable)e);
        }
    }

    @Override
    public Timestamp decode(CodecContext context, byte[] bytes) {
        TimeType type = context.getDataTypeAnnotation(TimeType.class);
        ByteOrder order = context.getByteOrder(type::byteOrder);
        return this.decode(bytes, type.offset(), order);
    }

    @Override
    public void encode(CodecContext context, ByteBuffer buffer, Timestamp value) {
        TimeType type = context.getDataTypeAnnotation(TimeType.class);
        ByteOrder order = context.getByteOrder(type::byteOrder);
        try {
            long mills = value.getTime();
            CodecUtils.int64Type(buffer, type.offset(), order, mills);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new EncodingException("Fail encoding times(timestamp) type.", (Throwable)e);
        }
    }
}

