/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import org.indunet.fastproto.ByteBuffer;
import org.indunet.fastproto.ByteOrder;
import org.indunet.fastproto.annotation.UInt32Type;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;

public class UInt32Codec
implements Codec<Long> {
    @Override
    public Long decode(CodecContext context, byte[] bytes) {
        UInt32Type type = context.getDataTypeAnnotation(UInt32Type.class);
        ByteOrder order = context.getByteOrder(type::byteOrder);
        try {
            return CodecUtils.uint32Type(bytes, type.offset(), order);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DecodingException("Fail decoding uint32 type.", (Throwable)e);
        }
    }

    @Override
    public void encode(CodecContext context, ByteBuffer buffer, Long value) {
        UInt32Type type = context.getDataTypeAnnotation(UInt32Type.class);
        ByteOrder order = context.getByteOrder(type::byteOrder);
        try {
            CodecUtils.uint32Type(buffer, type.offset(), order, (long)value);
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new EncodingException("Fail encoding uint32 type.", (Throwable)e);
        }
    }
}

