/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import java.math.BigInteger;
import org.indunet.fastproto.ByteBuffer;
import org.indunet.fastproto.ByteOrder;
import org.indunet.fastproto.annotation.UInt64Type;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;

public class UInt64Codec
implements Codec<BigInteger> {
    @Override
    public BigInteger decode(CodecContext context, byte[] bytes) {
        UInt64Type type = context.getDataTypeAnnotation(UInt64Type.class);
        ByteOrder order = context.getByteOrder(type::byteOrder);
        try {
            return CodecUtils.uint64Type(bytes, type.offset(), order);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DecodingException("Fail decoding uint64 type.", (Throwable)e);
        }
    }

    @Override
    public void encode(CodecContext context, ByteBuffer buffer, BigInteger value) {
        UInt64Type type = context.getDataTypeAnnotation(UInt64Type.class);
        ByteOrder order = context.getByteOrder(type::byteOrder);
        try {
            CodecUtils.uint64Type(buffer, type.offset(), order, value);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            throw new EncodingException("Fail encoding uint64 type.", (Throwable)e);
        }
    }
}

