/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import java.util.Arrays;
import java.util.Collection;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.indunet.fastproto.ByteBuffer;
import org.indunet.fastproto.annotation.UInt8ArrayType;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;
import org.indunet.fastproto.util.CollectionUtils;

public class UInt8ArrayCodec
implements Codec<int[]> {
    public int[] decode(byte[] bytes, int offset, int length) {
        try {
            int o = CodecUtils.reverse(bytes, offset);
            int l = CodecUtils.reverse(bytes, offset, length);
            return IntStream.range(0, l).map(i -> CodecUtils.uint8Type(bytes, o + i)).toArray();
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new DecodingException("Fail decoding uint8 array type.", (Throwable)e);
        }
    }

    public void encode(byte[] bytes, int offset, int length, int[] values) {
        try {
            int o = CodecUtils.reverse(bytes, offset);
            int l = CodecUtils.reverse(bytes, offset, length);
            IntStream.range(0, l).forEach(i -> CodecUtils.uint8Type(bytes, o + i, values[i]));
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new EncodingException("Fail encoding uint8 array type.", (Throwable)e);
        }
    }

    @Override
    public int[] decode(CodecContext context, byte[] bytes) {
        UInt8ArrayType type = context.getDataTypeAnnotation(UInt8ArrayType.class);
        return this.decode(bytes, type.offset(), type.length());
    }

    @Override
    public void encode(CodecContext context, ByteBuffer buffer, int[] values) {
        UInt8ArrayType type = context.getDataTypeAnnotation(UInt8ArrayType.class);
        try {
            int l = buffer.reverse(type.offset(), type.length());
            IntStream.range(0, l).forEach(i -> CodecUtils.uint8Type(buffer, type.offset() + i, values[i]));
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new EncodingException("Fail encoding uint8 array type.", (Throwable)e);
        }
    }

    public class CollectionCodec
    implements Codec<Collection<Integer>> {
        @Override
        public Collection<Integer> decode(CodecContext context, byte[] bytes) {
            try {
                Class<?> type = context.getFieldType();
                Collection collection = CollectionUtils.newInstance(type);
                Arrays.stream(UInt8ArrayCodec.this.decode(context, bytes)).forEach(collection::add);
                return collection;
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new DecodingException(String.format("Fail decoding collection type of %s", context.getFieldType().toString()), (Throwable)e);
            }
        }

        @Override
        public void encode(CodecContext context, ByteBuffer buffer, Collection<Integer> collection) {
            UInt8ArrayCodec.this.encode(context, buffer, collection.stream().mapToInt(Integer::intValue).toArray());
        }
    }

    public class WrapperCodec
    implements Codec<Integer[]> {
        @Override
        public Integer[] decode(CodecContext context, byte[] bytes) {
            return (Integer[])IntStream.of(UInt8ArrayCodec.this.decode(context, bytes)).mapToObj(Integer::valueOf).toArray(Integer[]::new);
        }

        @Override
        public void encode(CodecContext context, ByteBuffer buffer, Integer[] values) {
            int[] ints = Stream.of(values).mapToInt(i -> i).toArray();
            UInt8ArrayCodec.this.encode(context, buffer, ints);
        }
    }
}

