/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import org.indunet.fastproto.ByteBuffer;
import org.indunet.fastproto.annotation.UInt8Type;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.util.CodecUtils;

public class UInt8Codec
implements Codec<Integer> {
    @Override
    public Integer decode(CodecContext context, byte[] bytes) {
        UInt8Type type = context.getDataTypeAnnotation(UInt8Type.class);
        try {
            return CodecUtils.uint8Type(bytes, type.offset());
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new DecodingException("Fail decoding uint8 type.", (Throwable)e);
        }
    }

    @Override
    public void encode(CodecContext context, ByteBuffer buffer, Integer value) {
        UInt8Type type = context.getDataTypeAnnotation(UInt8Type.class);
        try {
            CodecUtils.uint8Type(buffer, type.offset(), (int)value);
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new EncodingException("Fail encoding uint8 type.", (Throwable)e);
        }
    }
}

