/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor;

import java.beans.Introspector;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.Messager;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleTypeVisitor6;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.inferred.freebuilder.processor.BuildablePropertyFactory;
import org.inferred.freebuilder.processor.BuilderFactory;
import org.inferred.freebuilder.processor.DefaultPropertyFactory;
import org.inferred.freebuilder.processor.ListMultimapPropertyFactory;
import org.inferred.freebuilder.processor.ListPropertyFactory;
import org.inferred.freebuilder.processor.MapPropertyFactory;
import org.inferred.freebuilder.processor.Metadata;
import org.inferred.freebuilder.processor.MethodFinder;
import org.inferred.freebuilder.processor.MethodIntrospector;
import org.inferred.freebuilder.processor.MultisetPropertyFactory;
import org.inferred.freebuilder.processor.OptionalPropertyFactory;
import org.inferred.freebuilder.processor.PropertyCodeGenerator;
import org.inferred.freebuilder.processor.SetMultimapPropertyFactory;
import org.inferred.freebuilder.processor.SetPropertyFactory;
import org.inferred.freebuilder.processor.util.IsInvalidTypeVisitor;
import org.inferred.freebuilder.processor.util.ModelUtils;
import org.inferred.freebuilder.processor.util.TypeReference;
import org.inferred.freebuilder.shaded.com.google.common.annotations.GwtCompatible;
import org.inferred.freebuilder.shaded.com.google.common.base.Functions;
import org.inferred.freebuilder.shaded.com.google.common.base.Objects;
import org.inferred.freebuilder.shaded.com.google.common.base.Optional;
import org.inferred.freebuilder.shaded.com.google.common.base.Preconditions;
import org.inferred.freebuilder.shaded.com.google.common.base.Predicate;
import org.inferred.freebuilder.shaded.com.google.common.collect.ImmutableList;
import org.inferred.freebuilder.shaded.com.google.common.collect.ImmutableMap;
import org.inferred.freebuilder.shaded.com.google.common.collect.ImmutableSet;
import org.inferred.freebuilder.shaded.com.google.common.collect.Iterables;
import org.inferred.freebuilder.shaded.com.google.common.collect.Sets;

class Analyser {
    private static final List<PropertyCodeGenerator.Factory> PROPERTY_FACTORIES = ImmutableList.of(new ListPropertyFactory(), new SetPropertyFactory(), new MapPropertyFactory(), new MultisetPropertyFactory(), new ListMultimapPropertyFactory(), new SetMultimapPropertyFactory(), new OptionalPropertyFactory(), new BuildablePropertyFactory(), new DefaultPropertyFactory());
    private static final String BUILDER_SIMPLE_NAME_TEMPLATE = "%s_Builder";
    private static final String USER_BUILDER_NAME = "Builder";
    private static final Pattern GETTER_PATTERN = Pattern.compile("^(get|is)(.+)");
    private static final String GET_PREFIX = "get";
    private static final String IS_PREFIX = "is";
    private final Elements elements;
    private final Messager messager;
    private final MethodIntrospector methodIntrospector;
    private final Types types;
    private static final SimpleTypeVisitor6<Boolean, ?> CAST_IS_FULLY_CHECKED = new SimpleTypeVisitor6<Boolean, Void>(){

        @Override
        public Boolean visitArray(ArrayType t, Void p) {
            return (Boolean)this.visit(t.getComponentType());
        }

        @Override
        public Boolean visitDeclared(DeclaredType t, Void p) {
            for (TypeMirror typeMirror : t.getTypeArguments()) {
                if (((Boolean)IS_UNBOUNDED_WILDCARD.visit(typeMirror)).booleanValue()) continue;
                return false;
            }
            return true;
        }

        @Override
        protected Boolean defaultAction(TypeMirror e, Void p) {
            return true;
        }
    };
    private static final SimpleTypeVisitor6<Boolean, ?> IS_UNBOUNDED_WILDCARD = new SimpleTypeVisitor6<Boolean, Void>(){

        @Override
        public Boolean visitWildcard(WildcardType t, Void p) {
            return t.getExtendsBound() == null || t.getExtendsBound().toString().equals("java.lang.Object");
        }

        @Override
        protected Boolean defaultAction(TypeMirror e, Void p) {
            return false;
        }
    };

    Analyser(Elements elements, Messager messager, MethodIntrospector methodIntrospector, Types types) {
        this.elements = elements;
        this.messager = messager;
        this.methodIntrospector = methodIntrospector;
        this.types = types;
    }

    Metadata analyse(TypeElement type) throws CannotGenerateCodeException {
        this.verifyType(type);
        PackageElement pkg = this.elements.getPackageOf(type);
        ImmutableSet<ExecutableElement> methods = MethodFinder.methodsOn(type, this.elements);
        TypeReference generatedBuilder = TypeReference.to(pkg.getQualifiedName().toString(), this.generatedBuilderSimpleName(type), new String[0]);
        Optional<TypeElement> builder = this.tryFindBuilder(generatedBuilder, type);
        TypeReference valueType = generatedBuilder.nestedType("Value");
        TypeReference partialType = generatedBuilder.nestedType("Partial");
        TypeReference propertyType = generatedBuilder.nestedType("Property");
        return new Metadata.Builder().setType(type).setBuilder(builder).setBuilderFactory(this.builderFactory(builder)).setGeneratedBuilder(generatedBuilder).setValueType(valueType).setPartialType(partialType).setPropertyEnum(propertyType).addVisibleNestedTypes(valueType).addVisibleNestedTypes(partialType).addVisibleNestedTypes(propertyType).addAllVisibleNestedTypes(Analyser.visibleTypesIn(type)).putAllStandardMethodUnderrides(this.findUnderriddenMethods(methods)).setBuilderSerializable(this.shouldBuilderBeSerializable(builder)).setGwtCompatible(Analyser.isGwtCompatible(type)).setGwtSerializable(Analyser.isGwtSerializable(type)).addAllProperties(this.findProperties(type, methods, builder).values()).build();
    }

    private static Set<TypeReference> visibleTypesIn(TypeElement type) {
        ImmutableSet.Builder visibleTypes = ImmutableSet.builder();
        for (TypeElement nestedType : ElementFilter.typesIn(type.getEnclosedElements())) {
            visibleTypes.add(TypeReference.to(nestedType));
        }
        visibleTypes.addAll(Analyser.visibleTypesIn(ModelUtils.maybeType(type.getEnclosingElement())));
        visibleTypes.addAll(Analyser.visibleTypesIn(ModelUtils.maybeAsTypeElement(type.getSuperclass())));
        return visibleTypes.build();
    }

    private static Set<TypeReference> visibleTypesIn(Optional<TypeElement> type) {
        if (!type.isPresent()) {
            return ImmutableSet.of();
        }
        return Analyser.visibleTypesIn(type.get());
    }

    private void verifyType(TypeElement type) throws CannotGenerateCodeException {
        switch (type.getNestingKind()) {
            case TOP_LEVEL: {
                break;
            }
            case MEMBER: {
                if (!type.getModifiers().contains((Object)Modifier.STATIC)) {
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "Inner classes cannot be @FreeBuilder types (did you forget the static keyword?)", type);
                    throw new CannotGenerateCodeException();
                }
                if (type.getModifiers().contains((Object)Modifier.PRIVATE)) {
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "@FreeBuilder types cannot be private", type);
                    throw new CannotGenerateCodeException();
                }
                for (Element e = type.getEnclosingElement(); e != null; e = e.getEnclosingElement()) {
                    if (!e.getModifiers().contains((Object)Modifier.PRIVATE)) continue;
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "@FreeBuilder types cannot be private, but enclosing type " + e.getSimpleName() + " is inaccessible", type);
                    throw new CannotGenerateCodeException();
                }
                break;
            }
            default: {
                this.messager.printMessage(Diagnostic.Kind.ERROR, "Only top-level or static nested types can be @FreeBuilder types", type);
                throw new CannotGenerateCodeException();
            }
        }
        if (!type.getTypeParameters().isEmpty()) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Generic @FreeBuilder types not yet supported (b/17278322)", type);
            throw new CannotGenerateCodeException();
        }
        switch (type.getKind()) {
            case ANNOTATION_TYPE: {
                this.messager.printMessage(Diagnostic.Kind.ERROR, "@FreeBuilder does not support annotation types", type);
                throw new CannotGenerateCodeException();
            }
            case CLASS: {
                this.verifyTypeIsConstructible(type);
                break;
            }
            case ENUM: {
                this.messager.printMessage(Diagnostic.Kind.ERROR, "@FreeBuilder does not support enum types", type);
                throw new CannotGenerateCodeException();
            }
            case INTERFACE: {
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected element kind " + (Object)((Object)type.getKind())));
            }
        }
    }

    private void verifyTypeIsConstructible(TypeElement type) throws CannotGenerateCodeException {
        List<ExecutableElement> constructors = ElementFilter.constructorsIn(type.getEnclosedElements());
        if (constructors.isEmpty()) {
            return;
        }
        for (ExecutableElement constructor : constructors) {
            if (!constructor.getParameters().isEmpty()) continue;
            if (constructor.getModifiers().contains((Object)Modifier.PRIVATE)) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, "@FreeBuilder types must have a package-visible no-args constructor", constructor);
                throw new CannotGenerateCodeException();
            }
            return;
        }
        this.messager.printMessage(Diagnostic.Kind.ERROR, "@FreeBuilder types must have a package-visible no-args constructor", type);
        throw new CannotGenerateCodeException();
    }

    private Map<Metadata.StandardMethod, Metadata.UnderrideLevel> findUnderriddenMethods(Iterable<ExecutableElement> methods) {
        LinkedHashMap<Metadata.StandardMethod, ExecutableElement> standardMethods = new LinkedHashMap<Metadata.StandardMethod, ExecutableElement>();
        for (ExecutableElement method : methods) {
            Object standardMethod = Analyser.maybeStandardMethod(method);
            if (!standardMethod.isPresent() || !Analyser.isUnderride(method)) continue;
            standardMethods.put(standardMethod.get(), method);
        }
        if (standardMethods.containsKey((Object)Metadata.StandardMethod.EQUALS) != standardMethods.containsKey((Object)Metadata.StandardMethod.HASH_CODE)) {
            ExecutableElement underriddenMethod = standardMethods.containsKey((Object)Metadata.StandardMethod.EQUALS) ? (ExecutableElement)standardMethods.get((Object)Metadata.StandardMethod.EQUALS) : (ExecutableElement)standardMethods.get((Object)Metadata.StandardMethod.HASH_CODE);
            this.messager.printMessage(Diagnostic.Kind.ERROR, "hashCode and equals must be implemented together on @FreeBuilder types", underriddenMethod);
        }
        ImmutableMap.Builder<Optional<Metadata.StandardMethod>, Metadata.UnderrideLevel> result = ImmutableMap.builder();
        for (Object standardMethod : standardMethods.keySet()) {
            if (((ExecutableElement)standardMethods.get(standardMethod)).getModifiers().contains((Object)Modifier.FINAL)) {
                result.put((Optional<Metadata.StandardMethod>)standardMethod, Metadata.UnderrideLevel.FINAL);
                continue;
            }
            result.put((Optional<Metadata.StandardMethod>)standardMethod, Metadata.UnderrideLevel.OVERRIDEABLE);
        }
        return result.build();
    }

    private static boolean isUnderride(ExecutableElement method) {
        return !method.getModifiers().contains((Object)Modifier.ABSTRACT);
    }

    private Optional<TypeElement> tryFindBuilder(TypeReference generatedBuilder, TypeElement type) {
        Optional<Element> userClass = Iterables.tryFind(ElementFilter.typesIn(type.getEnclosedElements()), new Predicate<Element>(){

            @Override
            public boolean apply(Element input) {
                return input.getSimpleName().contentEquals(Analyser.USER_BUILDER_NAME);
            }
        });
        if (!userClass.isPresent()) {
            if (type.getKind() == ElementKind.INTERFACE) {
                this.messager.printMessage(Diagnostic.Kind.NOTE, "Add \"class Builder extends " + generatedBuilder.getSimpleName() + " {}\" to your interface to enable the @FreeBuilder API", type);
            } else {
                this.messager.printMessage(Diagnostic.Kind.NOTE, "Add \"public static class Builder extends " + generatedBuilder.getSimpleName() + " {}\" to your class to enable the @FreeBuilder API", type);
            }
            return Optional.absent();
        }
        boolean extendsSuperclass = (Boolean)new IsSubclassOfGeneratedTypeVisitor(generatedBuilder).visit(((TypeElement)userClass.get()).getSuperclass());
        if (!extendsSuperclass) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Builder extends the wrong type (should be " + generatedBuilder.getSimpleName() + ")", userClass.get());
            return Optional.absent();
        }
        return userClass;
    }

    private Optional<BuilderFactory> builderFactory(Optional<TypeElement> builder) {
        if (!builder.isPresent()) {
            return Optional.of(BuilderFactory.NO_ARGS_CONSTRUCTOR);
        }
        if (!builder.get().getModifiers().contains((Object)Modifier.STATIC)) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Builder must be static on @FreeBuilder types", builder.get());
            return Optional.absent();
        }
        return BuilderFactory.from(builder.get());
    }

    private Map<String, Metadata.Property> findProperties(TypeElement type, Iterable<ExecutableElement> methods, Optional<TypeElement> builder) {
        Set<String> methodsInvokedInBuilderConstructor = this.getMethodsInvokedInBuilderConstructor(builder);
        LinkedHashMap<String, Metadata.Property> propertiesByName = new LinkedHashMap<String, Metadata.Property>();
        for (ExecutableElement method : methods) {
            Metadata.Property property = this.asPropertyOrNull(type, method, methodsInvokedInBuilderConstructor);
            if (property == null) continue;
            propertiesByName.put(property.getName(), property);
        }
        return propertiesByName;
    }

    private Set<String> getMethodsInvokedInBuilderConstructor(Optional<TypeElement> builder) {
        if (!builder.isPresent()) {
            return ImmutableSet.of();
        }
        List<ExecutableElement> constructors = ElementFilter.constructorsIn(builder.get().getEnclosedElements());
        if (constructors.isEmpty()) {
            return ImmutableSet.of();
        }
        Set<Name> result = null;
        for (ExecutableElement constructor : constructors) {
            if (result == null) {
                result = this.methodIntrospector.getOwnMethodInvocations(constructor);
                continue;
            }
            result = Sets.intersection(result, this.methodIntrospector.getOwnMethodInvocations(constructor));
        }
        return ImmutableSet.copyOf(Iterables.transform(result, Functions.toStringFunction()));
    }

    private Metadata.Property asPropertyOrNull(TypeElement valueType, ExecutableElement method, Set<String> methodsInvokedInBuilderConstructor) {
        MatchResult getterNameMatchResult = this.getterNameMatchResult(valueType, method);
        if (getterNameMatchResult == null) {
            return null;
        }
        String getterName = getterNameMatchResult.group(0);
        TypeMirror propertyType = this.getReturnType(valueType, method);
        String camelCaseName = Introspector.decapitalize(getterNameMatchResult.group(2));
        Metadata.Property.Builder resultBuilder = new Metadata.Property.Builder().setType(propertyType).setName(camelCaseName).setCapitalizedName(getterNameMatchResult.group(2)).setAllCapsName(Analyser.camelCaseToAllCaps(camelCaseName)).setGetterName(getterName).setFullyCheckedCast((Boolean)CAST_IS_FULLY_CHECKED.visit(propertyType)).addAllNullableAnnotations(Analyser.nullableAnnotationsOn(method));
        if (propertyType.getKind().isPrimitive()) {
            PrimitiveType unboxedType = this.types.getPrimitiveType(propertyType.getKind());
            TypeMirror boxedType = this.types.erasure(this.types.boxedClass(unboxedType).asType());
            resultBuilder.setBoxedType(boxedType);
        }
        Metadata.Property propertyWithoutCodeGenerator = resultBuilder.build();
        resultBuilder.setCodeGenerator(this.createCodeGenerator(propertyWithoutCodeGenerator, methodsInvokedInBuilderConstructor));
        return resultBuilder.build();
    }

    private TypeMirror getReturnType(TypeElement type, ExecutableElement method) {
        try {
            ExecutableType executableType = (ExecutableType)this.types.asMemberOf((DeclaredType)type.asType(), method);
            return executableType.getReturnType();
        }
        catch (IllegalArgumentException e) {
            return method.getReturnType();
        }
    }

    private static ImmutableSet<TypeElement> nullableAnnotationsOn(ExecutableElement getterMethod) {
        ImmutableSet.Builder nullableAnnotations = ImmutableSet.builder();
        for (AnnotationMirror annotationMirror : getterMethod.getAnnotationMirrors()) {
            TypeElement type;
            if (!annotationMirror.getElementValues().isEmpty() || !(type = (TypeElement)annotationMirror.getAnnotationType().asElement()).getSimpleName().contentEquals("Nullable")) continue;
            nullableAnnotations.add(type);
        }
        return nullableAnnotations.build();
    }

    private PropertyCodeGenerator createCodeGenerator(Metadata.Property propertyWithoutCodeGenerator, Set<String> methodsInvokedInBuilderConstructor) {
        ConfigImpl config = new ConfigImpl(propertyWithoutCodeGenerator, methodsInvokedInBuilderConstructor);
        for (PropertyCodeGenerator.Factory factory : PROPERTY_FACTORIES) {
            Optional<? extends PropertyCodeGenerator> codeGenerator = factory.create(config);
            if (!codeGenerator.isPresent()) continue;
            return codeGenerator.get();
        }
        throw new AssertionError((Object)"DefaultPropertyFactory not registered");
    }

    private MatchResult getterNameMatchResult(TypeElement valueType, ExecutableElement method) {
        if (Analyser.maybeStandardMethod(method).isPresent()) {
            return null;
        }
        Set<Modifier> modifiers = method.getModifiers();
        if (!modifiers.contains((Object)Modifier.ABSTRACT)) {
            return null;
        }
        boolean declaredOnValueType = method.getEnclosingElement().equals(valueType);
        String name = method.getSimpleName().toString();
        Matcher getterMatcher = GETTER_PATTERN.matcher(name);
        if (!getterMatcher.matches()) {
            if (declaredOnValueType) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, "Only getter methods (starting with 'get' or 'is') may be declared abstract on @FreeBuilder types", method);
            } else {
                this.printNoImplementationMessage(valueType, method);
            }
            return null;
        }
        String prefix = getterMatcher.group(1);
        String suffix = getterMatcher.group(2);
        if (Analyser.hasUpperCase(suffix.codePointAt(0))) {
            if (declaredOnValueType) {
                String message = new StringBuilder().append("Getter methods cannot have a lowercase character immediately after the '").append(prefix).append("' prefix on @FreeBuilder types (did you mean '").append(prefix).appendCodePoint(Character.toUpperCase(suffix.codePointAt(0))).append(suffix.substring(suffix.offsetByCodePoints(0, 1))).append("'?)").toString();
                this.messager.printMessage(Diagnostic.Kind.ERROR, message, method);
            } else {
                this.printNoImplementationMessage(valueType, method);
            }
            return null;
        }
        TypeMirror returnType = this.getReturnType(valueType, method);
        if (returnType.getKind() == TypeKind.VOID) {
            if (declaredOnValueType) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, "Getter methods must not be void on @FreeBuilder types", method);
            } else {
                this.printNoImplementationMessage(valueType, method);
            }
            return null;
        }
        if (prefix.equals(IS_PREFIX) && returnType.getKind() != TypeKind.BOOLEAN) {
            if (declaredOnValueType) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, "Getter methods starting with 'is' must return a boolean on @FreeBuilder types", method);
            } else {
                this.printNoImplementationMessage(valueType, method);
            }
            return null;
        }
        if (!method.getParameters().isEmpty()) {
            if (declaredOnValueType) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, "Getter methods cannot take parameters on @FreeBuilder types", method);
            } else {
                this.printNoImplementationMessage(valueType, method);
            }
            return null;
        }
        if (((Boolean)new IsInvalidTypeVisitor().visit(returnType)).booleanValue()) {
            return null;
        }
        return getterMatcher.toMatchResult();
    }

    private void printNoImplementationMessage(TypeElement valueType, ExecutableElement method) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, "No implementation found for non-getter method '" + method + "'; " + "cannot generate @FreeBuilder implementation", valueType);
    }

    private String generatedBuilderSimpleName(TypeElement type) {
        String packageName = this.elements.getPackageOf(type).getQualifiedName().toString();
        String originalName = type.getQualifiedName().toString();
        Preconditions.checkState(originalName.startsWith(packageName + "."));
        String nameWithoutPackage = originalName.substring(packageName.length() + 1);
        return String.format(BUILDER_SIMPLE_NAME_TEMPLATE, nameWithoutPackage.replaceAll("\\.", "_"));
    }

    private boolean shouldBuilderBeSerializable(Optional<TypeElement> builder) {
        if (!builder.isPresent()) {
            return true;
        }
        return Iterables.any(builder.get().getInterfaces(), this.isEqualTo(Serializable.class));
    }

    private static final boolean hasUpperCase(int codepoint) {
        return Character.toUpperCase(codepoint) != codepoint;
    }

    private static boolean isGwtCompatible(TypeElement type) {
        return ModelUtils.findAnnotationMirror((Element)type, GwtCompatible.class).isPresent();
    }

    private static boolean isGwtSerializable(TypeElement type) {
        Optional<AnnotationMirror> annotation = ModelUtils.findAnnotationMirror((Element)type, GwtCompatible.class);
        if (!annotation.isPresent()) {
            return false;
        }
        Optional<AnnotationValue> serializable = ModelUtils.findProperty(annotation.get(), "serializable");
        if (!serializable.isPresent()) {
            return false;
        }
        return serializable.get().getValue().equals(Boolean.TRUE);
    }

    private static Optional<Metadata.StandardMethod> maybeStandardMethod(ExecutableElement method) {
        String methodName = method.getSimpleName().toString();
        if (methodName.equals("equals")) {
            if (method.getParameters().size() == 1 && method.getParameters().get(0).asType().toString().equals("java.lang.Object")) {
                return Optional.of(Metadata.StandardMethod.EQUALS);
            }
            return Optional.absent();
        }
        if (methodName.equals("hashCode")) {
            if (method.getParameters().isEmpty()) {
                return Optional.of(Metadata.StandardMethod.HASH_CODE);
            }
            return Optional.absent();
        }
        if (methodName.equals("toString")) {
            if (method.getParameters().isEmpty()) {
                return Optional.of(Metadata.StandardMethod.TO_STRING);
            }
            return Optional.absent();
        }
        return Optional.absent();
    }

    private static String camelCaseToAllCaps(String camelCase) {
        return camelCase.replaceAll("(?<=[^A-Z])(?=[A-Z])|(?<=[A-Z])(?=[A-Z][^A-Z])", "_").toUpperCase();
    }

    private Predicate<TypeMirror> isEqualTo(Class<?> cls) {
        final TypeMirror typeMirror = this.elements.getTypeElement(cls.getCanonicalName()).asType();
        return new Predicate<TypeMirror>(){

            @Override
            public boolean apply(TypeMirror input) {
                return Analyser.this.types.isSameType(input, typeMirror);
            }
        };
    }

    private static final class IsSubclassOfGeneratedTypeVisitor
    extends SimpleTypeVisitor6<Boolean, Void> {
        private final TypeReference superclass;

        private IsSubclassOfGeneratedTypeVisitor(TypeReference superclass) {
            super(false);
            this.superclass = superclass;
        }

        @Override
        public Boolean visitError(ErrorType t, Void p) {
            String simpleName = t.toString();
            return Objects.equal(simpleName, this.superclass.getSimpleName());
        }

        @Override
        public Boolean visitDeclared(DeclaredType t, Void p) {
            String qualifiedName = t.toString();
            return Objects.equal(qualifiedName, this.superclass.getQualifiedName());
        }
    }

    private class ConfigImpl
    implements PropertyCodeGenerator.Config {
        final Metadata.Property property;
        final Set<String> methodsInvokedInBuilderConstructor;

        ConfigImpl(Metadata.Property property, Set<String> methodsInvokedInBuilderConstructor) {
            this.property = property;
            this.methodsInvokedInBuilderConstructor = methodsInvokedInBuilderConstructor;
        }

        @Override
        public Metadata.Property getProperty() {
            return this.property;
        }

        @Override
        public Set<String> getMethodsInvokedInBuilderConstructor() {
            return this.methodsInvokedInBuilderConstructor;
        }

        @Override
        public Elements getElements() {
            return Analyser.this.elements;
        }

        @Override
        public Types getTypes() {
            return Analyser.this.types;
        }
    }

    public static class CannotGenerateCodeException
    extends Exception {
    }
}

