/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor;

import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;
import org.inferred.freebuilder.processor.BuilderFactory;
import org.inferred.freebuilder.processor.Metadata;
import org.inferred.freebuilder.processor.PropertyCodeGenerator;
import org.inferred.freebuilder.processor.util.ModelUtils;
import org.inferred.freebuilder.processor.util.SourceBuilder;
import org.inferred.freebuilder.shaded.com.google.common.annotations.VisibleForTesting;
import org.inferred.freebuilder.shaded.com.google.common.base.Optional;
import org.inferred.freebuilder.shaded.com.google.common.base.Preconditions;
import org.inferred.freebuilder.shaded.com.google.common.base.Predicate;
import org.inferred.freebuilder.shaded.com.google.common.collect.FluentIterable;
import org.inferred.freebuilder.shaded.com.google.common.collect.ImmutableList;
import org.inferred.freebuilder.shaded.com.google.common.collect.Iterables;

public class BuildablePropertyFactory
implements PropertyCodeGenerator.Factory {
    private static final String SET_PREFIX = "set";
    private static final String GET_BUILDER_PREFIX = "get";
    private static final String GET_BUILDER_SUFFIX = "Builder";
    private static final Predicate<Element> IS_BUILDER_TYPE = new Predicate<Element>(){

        @Override
        public boolean apply(Element element) {
            return element.getSimpleName().contentEquals(BuildablePropertyFactory.GET_BUILDER_SUFFIX);
        }
    };

    @Override
    public Optional<? extends PropertyCodeGenerator> create(PropertyCodeGenerator.Config config) {
        MergeBuilderMethod mergeFromBuilderMethod;
        if (!config.getProperty().getNullableAnnotations().isEmpty()) {
            return Optional.absent();
        }
        TypeMirror type = config.getProperty().getType();
        if (type.getKind() != TypeKind.DECLARED) {
            return Optional.absent();
        }
        TypeElement element = (TypeElement)((DeclaredType)type).asElement();
        Optional<Element> builder = Iterables.tryFind(ElementFilter.typesIn(element.getEnclosedElements()), IS_BUILDER_TYPE);
        if (!builder.isPresent()) {
            return Optional.absent();
        }
        Optional<BuilderFactory> builderFactory = BuilderFactory.from((TypeElement)builder.get());
        if (!builderFactory.isPresent()) {
            return Optional.absent();
        }
        if (ModelUtils.findAnnotationMirror((Element)element, "org.inferred.freebuilder.FreeBuilder").isPresent()) {
            mergeFromBuilderMethod = MergeBuilderMethod.MERGE_DIRECTLY;
        } else {
            ImmutableList<ExecutableElement> methods = FluentIterable.from(config.getElements().getAllMembers((TypeElement)builder.get())).filter(ExecutableElement.class).filter(new IsCallableMethod()).toList();
            if (!Iterables.any(methods, new IsBuildMethod("build", type, config.getTypes()))) {
                return Optional.absent();
            }
            if (!Iterables.any(methods, new IsBuildMethod("buildPartial", type, config.getTypes()))) {
                return Optional.absent();
            }
            if (!Iterables.any(methods, new IsClearMethod())) {
                return Optional.absent();
            }
            if (!Iterables.any(methods, new IsMergeFromMethod(type, config.getTypes()))) {
                return Optional.absent();
            }
            mergeFromBuilderMethod = Iterables.any(methods, new IsMergeFromMethod(((TypeElement)builder.get()).asType(), config.getTypes())) ? MergeBuilderMethod.MERGE_DIRECTLY : MergeBuilderMethod.BUILD_PARTIAL_AND_MERGE;
        }
        String setterName = SET_PREFIX + config.getProperty().getCapitalizedName();
        String getBuilderName = GET_BUILDER_PREFIX + config.getProperty().getCapitalizedName() + GET_BUILDER_SUFFIX;
        return Optional.of(new CodeGenerator(config.getProperty(), (TypeElement)builder.get(), builderFactory.get(), setterName, getBuilderName, mergeFromBuilderMethod));
    }

    private static final class IsMergeFromMethod
    implements Predicate<ExecutableElement> {
        final TypeMirror builderType;
        final Types types;

        IsMergeFromMethod(TypeMirror sourceType, Types types) {
            this.builderType = sourceType;
            this.types = types;
        }

        @Override
        public boolean apply(ExecutableElement element) {
            if (element.getParameters().size() != 1) {
                return false;
            }
            if (!element.getSimpleName().contentEquals("mergeFrom")) {
                return false;
            }
            return this.types.isSubtype(this.builderType, element.getParameters().get(0).asType());
        }
    }

    private static final class IsClearMethod
    implements Predicate<ExecutableElement> {
        private IsClearMethod() {
        }

        @Override
        public boolean apply(ExecutableElement element) {
            if (!element.getParameters().isEmpty()) {
                return false;
            }
            return element.getSimpleName().contentEquals("clear");
        }
    }

    private static final class IsBuildMethod
    implements Predicate<ExecutableElement> {
        final String methodName;
        final TypeMirror builtType;
        final Types types;

        IsBuildMethod(String methodName, TypeMirror builtType, Types types) {
            this.methodName = methodName;
            this.builtType = builtType;
            this.types = types;
        }

        @Override
        public boolean apply(ExecutableElement element) {
            if (!element.getParameters().isEmpty()) {
                return false;
            }
            if (!element.getSimpleName().contentEquals(this.methodName)) {
                return false;
            }
            return this.types.isSubtype(element.getReturnType(), this.builtType);
        }
    }

    private static final class IsCallableMethod
    implements Predicate<ExecutableElement> {
        private IsCallableMethod() {
        }

        @Override
        public boolean apply(ExecutableElement element) {
            boolean isMethod = element.getKind() == ElementKind.METHOD;
            boolean isPublic = element.getModifiers().contains((Object)Modifier.PUBLIC);
            boolean isNotStatic = !element.getModifiers().contains((Object)Modifier.STATIC);
            boolean declaresNoExceptions = element.getThrownTypes().isEmpty();
            return isMethod && isPublic && isNotStatic && declaresNoExceptions;
        }
    }

    @VisibleForTesting
    static class CodeGenerator
    extends PropertyCodeGenerator {
        final TypeElement builderType;
        final BuilderFactory builderFactory;
        final String setterName;
        final String getBuilderName;
        final MergeBuilderMethod mergeFromBuilderMethod;

        CodeGenerator(Metadata.Property property, TypeElement builderType, BuilderFactory builderFactory, String setterName, String getBuilderName, MergeBuilderMethod mergeFromBuilderMethod) {
            super(property);
            this.builderType = builderType;
            this.builderFactory = builderFactory;
            this.setterName = setterName;
            this.getBuilderName = getBuilderName;
            this.mergeFromBuilderMethod = mergeFromBuilderMethod;
        }

        @Override
        public void addBuilderFieldDeclaration(SourceBuilder code) {
            code.add("private final %s %s = ", this.builderType, this.property.getName());
            this.builderFactory.addNewBuilder(code, this.builderType);
            code.add(";\n", new Object[0]);
        }

        @Override
        public void addBuilderFieldAccessors(SourceBuilder code, Metadata metadata) {
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Sets the value to be returned by {@link %s#%s()}.", metadata.getType(), this.property.getGetterName()).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", metadata.getBuilder().getSimpleName()).addLine(" * @throws NullPointerException if {@code %s} is null", this.property.getName()).addLine(" */", new Object[0]).addLine("public %s %s(%s %s) {", metadata.getBuilder(), this.setterName, this.property.getType(), this.property.getName()).addLine("  this.%s.clear();", this.property.getName()).addLine("  this.%1$s.mergeFrom(%2$s.checkNotNull(%1$s));", this.property.getName(), Preconditions.class).addLine("  return (%s) this;", metadata.getBuilder()).addLine("}", new Object[0]);
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Sets the value to be returned by {@link %s#%s()}.", metadata.getType(), this.property.getGetterName()).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", metadata.getBuilder().getSimpleName()).addLine(" * @throws NullPointerException if {@code builder} is null", new Object[0]).addLine(" */", new Object[0]).addLine("public %s %s(%s.Builder builder) {", metadata.getBuilder(), this.setterName, this.property.getType()).addLine("  return %s(builder.build());", this.setterName).addLine("}", new Object[0]);
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Returns a builder for the value that will be returned by {@link %s#%s()}.", metadata.getType(), this.property.getGetterName()).addLine(" */", new Object[0]).addLine("public %s %s() {", this.builderType, this.getBuilderName).addLine("  return %s;", this.property.getName()).addLine("}", new Object[0]);
        }

        @Override
        public void addFinalFieldAssignment(SourceBuilder code, String finalField, String builder) {
            code.addLine("%s = %s.%s.build();", finalField, builder, this.property.getName());
        }

        @Override
        public void addPartialFieldAssignment(SourceBuilder code, String finalField, String builder) {
            code.addLine("%s = %s.%s.buildPartial();", finalField, builder, this.property.getName());
        }

        @Override
        public void addMergeFromValue(SourceBuilder code, String value) {
            code.addLine("%s.mergeFrom(%s.%s());", this.property.getName(), value, this.property.getGetterName());
        }

        @Override
        public void addMergeFromBuilder(SourceBuilder code, Metadata metadata, String builder) {
            code.add("%s.mergeFrom(%s.%s()", this.property.getName(), builder, this.getBuilderName);
            if (this.mergeFromBuilderMethod == MergeBuilderMethod.BUILD_PARTIAL_AND_MERGE) {
                code.add(".buildPartial()", new Object[0]);
            }
            code.add(");\n", new Object[0]);
        }

        @Override
        public void addSetFromResult(SourceBuilder code, String builder, String variable) {
            code.addLine("%s.%s(%s);", builder, this.setterName, variable);
        }

        @Override
        public boolean isTemplateRequiredInClear() {
            return false;
        }

        @Override
        public void addClear(SourceBuilder code, String template) {
            code.addLine("%s.clear();", this.property.getName());
        }

        @Override
        public void addPartialClear(SourceBuilder code) {
            code.addLine("%s.clear();", this.property.getName());
        }
    }

    private static enum MergeBuilderMethod {
        MERGE_DIRECTLY,
        BUILD_PARTIAL_AND_MERGE;

    }
}

