/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor;

import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.inferred.freebuilder.processor.util.SourceBuilder;
import org.inferred.freebuilder.shaded.com.google.common.base.Optional;
import org.inferred.freebuilder.shaded.com.google.common.collect.ImmutableSet;

public enum BuilderFactory {
    NO_ARGS_CONSTRUCTOR{

        @Override
        public void addNewBuilder(SourceBuilder code, TypeElement builderType) {
            code.add("new %s()", builderType);
        }
    }
    ,
    BUILDER_METHOD{

        @Override
        public void addNewBuilder(SourceBuilder code, TypeElement builderType) {
            code.add("%s.builder()", builderType.getEnclosingElement());
        }
    }
    ,
    NEW_BUILDER_METHOD{

        @Override
        public void addNewBuilder(SourceBuilder code, TypeElement builderType) {
            code.add("%s.newBuilder()", builderType.getEnclosingElement());
        }
    };


    public static Optional<BuilderFactory> from(TypeElement builderType) {
        ImmutableSet<String> staticMethods = BuilderFactory.findPotentialStaticFactoryMethods(builderType);
        if (staticMethods.contains("builder")) {
            return Optional.of(BUILDER_METHOD);
        }
        if (staticMethods.contains("newBuilder")) {
            return Optional.of(NEW_BUILDER_METHOD);
        }
        if (BuilderFactory.hasExplicitNoArgsConstructor(builderType)) {
            return Optional.of(NO_ARGS_CONSTRUCTOR);
        }
        return Optional.absent();
    }

    public abstract void addNewBuilder(SourceBuilder var1, TypeElement var2);

    private static boolean hasExplicitNoArgsConstructor(TypeElement type) {
        for (ExecutableElement constructor : ElementFilter.constructorsIn(type.getEnclosedElements())) {
            if (!constructor.getParameters().isEmpty() || constructor.getModifiers().contains((Object)Modifier.PRIVATE)) continue;
            return true;
        }
        return false;
    }

    private static ImmutableSet<String> findPotentialStaticFactoryMethods(TypeElement builderType) {
        ImmutableSet.Builder resultBuilder = ImmutableSet.builder();
        Element valueType = builderType.getEnclosingElement();
        for (ExecutableElement method : ElementFilter.methodsIn(valueType.getEnclosedElements())) {
            Set<Modifier> modifiers = method.getModifiers();
            if (!modifiers.contains((Object)Modifier.STATIC) || modifiers.contains((Object)Modifier.PRIVATE) || !method.getParameters().isEmpty() || !builderType.asType().toString().equals(method.getReturnType().toString())) continue;
            resultBuilder.add(method.getSimpleName().toString());
        }
        return resultBuilder.build();
    }
}

