/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor;

import java.io.Serializable;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Generated;
import javax.lang.model.element.TypeElement;
import org.inferred.freebuilder.processor.Metadata;
import org.inferred.freebuilder.processor.PropertyCodeGenerator;
import org.inferred.freebuilder.processor.util.SourceBuilder;
import org.inferred.freebuilder.processor.util.SourceBuilders;
import org.inferred.freebuilder.processor.util.TypeReference;
import org.inferred.freebuilder.shaded.com.google.common.annotations.GwtCompatible;
import org.inferred.freebuilder.shaded.com.google.common.annotations.VisibleForTesting;
import org.inferred.freebuilder.shaded.com.google.common.base.Joiner;
import org.inferred.freebuilder.shaded.com.google.common.base.Preconditions;
import org.inferred.freebuilder.shaded.com.google.common.base.Predicate;
import org.inferred.freebuilder.shaded.com.google.common.collect.ImmutableCollection;
import org.inferred.freebuilder.shaded.com.google.common.collect.ImmutableList;
import org.inferred.freebuilder.shaded.com.google.common.collect.Iterables;
import org.inferred.freebuilder.shaded.com.google.common.collect.Lists;

public class CodeGenerator {
    private static final TypeReference CUSTOM_FIELD_SERIALIZER = TypeReference.to("org.inferred.freebuilder.shaded.com.google.gwt.user.client.rpc", "CustomFieldSerializer", new String[0]);
    private static final TypeReference SERIALIZATION_EXCEPTION = TypeReference.to("org.inferred.freebuilder.shaded.com.google.gwt.user.client.rpc", "SerializationException", new String[0]);
    private static final TypeReference SERIALIZATION_STREAM_READER = TypeReference.to("org.inferred.freebuilder.shaded.com.google.gwt.user.client.rpc", "SerializationStreamReader", new String[0]);
    private static final TypeReference SERIALIZATION_STREAM_WRITER = TypeReference.to("org.inferred.freebuilder.shaded.com.google.gwt.user.client.rpc", "SerializationStreamWriter", new String[0]);
    private static final Predicate<Metadata.Property> IS_REQUIRED = new Predicate<Metadata.Property>(){

        @Override
        public boolean apply(Metadata.Property property) {
            return property.getCodeGenerator().getType() == PropertyCodeGenerator.Type.REQUIRED;
        }
    };
    private static final Predicate<Metadata.Property> IS_OPTIONAL = new Predicate<Metadata.Property>(){

        @Override
        public boolean apply(Metadata.Property property) {
            return property.getCodeGenerator().getType() == PropertyCodeGenerator.Type.OPTIONAL;
        }
    };

    void writeBuilderSource(SourceBuilder code, Metadata metadata) {
        if (!metadata.hasBuilder()) {
            this.writeStubSource(code, metadata);
            return;
        }
        this.addBuilderTypeDeclaration(code, metadata);
        code.addLine(" {", new Object[0]);
        SourceBuilder body = SourceBuilders.withIndent(code, 2);
        CodeGenerator.addConstantDeclarations(metadata, body);
        if (Iterables.any(metadata.getProperties(), IS_REQUIRED)) {
            CodeGenerator.addPropertyEnum(metadata, body);
        }
        CodeGenerator.addFieldDeclarations(body, metadata);
        CodeGenerator.addAccessors(metadata, body);
        CodeGenerator.addMergeFromValueMethod(body, metadata);
        CodeGenerator.addMergeFromBuilderMethod(body, metadata);
        CodeGenerator.addClearMethod(body, metadata);
        CodeGenerator.addBuildMethod(body, metadata);
        CodeGenerator.addBuildPartialMethod(body, metadata);
        CodeGenerator.addValueType(body, metadata);
        if (metadata.isGwtSerializable()) {
            CodeGenerator.addCustomValueSerializer(body, metadata);
            CodeGenerator.addGwtWhitelistType(body, metadata);
        }
        CodeGenerator.addPartialType(body, metadata);
        code.addLine("}", new Object[0]);
    }

    private void addBuilderTypeDeclaration(SourceBuilder code, Metadata metadata) {
        code.addLine("/**", new Object[0]).addLine(" * Auto-generated superclass of {@link %s},", metadata.getBuilder()).addLine(" * derived from the API of {@link %s}.", metadata.getType()).addLine(" */", new Object[0]).addLine("@%s(\"%s\")", Generated.class, this.getClass().getName());
        if (metadata.isGwtCompatible()) {
            code.addLine("@%s", GwtCompatible.class);
        }
        code.add("abstract class %s", metadata.getGeneratedBuilder().getSimpleName());
        if (metadata.isBuilderSerializable()) {
            code.add(" implements %s", Serializable.class);
        }
    }

    private static void addConstantDeclarations(Metadata metadata, SourceBuilder body) {
        if (metadata.getProperties().size() > 1) {
            body.addLine("", new Object[0]).addLine("private static final %1$s COMMA_JOINER = %1$s.on(\", \").skipNulls();", Joiner.class);
        }
    }

    private static void addFieldDeclarations(SourceBuilder code, Metadata metadata) {
        code.addLine("", new Object[0]);
        for (Metadata.Property property : metadata.getProperties()) {
            PropertyCodeGenerator codeGenerator = property.getCodeGenerator();
            codeGenerator.addBuilderFieldDeclaration(code);
        }
        if (Iterables.any(metadata.getProperties(), IS_REQUIRED)) {
            code.addLine("private final %s<%s> _unsetProperties =", EnumSet.class, metadata.getPropertyEnum()).addLine("    %s.allOf(%s.class);", EnumSet.class, metadata.getPropertyEnum());
        }
    }

    private static void addAccessors(Metadata metadata, SourceBuilder body) {
        for (Metadata.Property property : metadata.getProperties()) {
            property.getCodeGenerator().addBuilderFieldAccessors(body, metadata);
        }
    }

    private static void addBuildMethod(SourceBuilder code, Metadata metadata) {
        boolean hasRequiredProperties = Iterables.any(metadata.getProperties(), IS_REQUIRED);
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Returns a newly-created {@link %s} based on the contents of the {@code %s}.", metadata.getType(), metadata.getBuilder().getSimpleName());
        if (hasRequiredProperties) {
            code.addLine(" *", new Object[0]).addLine(" * @throws IllegalStateException if any field has not been set", new Object[0]);
        }
        code.addLine(" */", new Object[0]).addLine("public %s build() {", metadata.getType());
        if (hasRequiredProperties) {
            code.addLine("  %s.checkState(_unsetProperties.isEmpty(), \"Not set: %%s\", _unsetProperties);", Preconditions.class);
        }
        code.addLine("  return new %s(this);", metadata.getValueType()).addLine("}", new Object[0]);
    }

    private static void addMergeFromValueMethod(SourceBuilder code, Metadata metadata) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Sets all property values using the given {@code %s} as a template.", metadata.getType()).addLine(" */", new Object[0]).addLine("public %s mergeFrom(%s value) {", metadata.getBuilder(), metadata.getType());
        for (Metadata.Property property : metadata.getProperties()) {
            property.getCodeGenerator().addMergeFromValue(SourceBuilders.withIndent(code, 2), "value");
        }
        code.addLine("  return (%s) this;", metadata.getBuilder());
        code.addLine("}", new Object[0]);
    }

    private static void addMergeFromBuilderMethod(SourceBuilder code, Metadata metadata) {
        boolean hasRequiredProperties = Iterables.any(metadata.getProperties(), IS_REQUIRED);
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Copies values from the given {@code %s}.", metadata.getBuilder().getSimpleName());
        if (hasRequiredProperties) {
            code.addLine(" * Does not affect any properties not set on the input.", new Object[0]);
        }
        code.addLine(" */", new Object[0]).addLine("public %1$s mergeFrom(%1$s template) {", metadata.getBuilder());
        if (hasRequiredProperties) {
            code.addLine("  // Upcast to access the private _unsetProperties field.", new Object[0]).addLine("  // Otherwise, oddly, we get an access violation.", new Object[0]).addLine("  %s<%s> _templateUnset = ((%s) template)._unsetProperties;", EnumSet.class, metadata.getPropertyEnum(), metadata.getGeneratedBuilder());
        }
        for (Metadata.Property property : metadata.getProperties()) {
            if (property.getCodeGenerator().getType() == PropertyCodeGenerator.Type.REQUIRED) {
                code.addLine("  if (!_templateUnset.contains(%s.%s)) {", metadata.getPropertyEnum(), property.getAllCapsName());
                property.getCodeGenerator().addMergeFromBuilder(SourceBuilders.withIndent(code, 4), metadata, "template");
                code.addLine("  }", new Object[0]);
                continue;
            }
            property.getCodeGenerator().addMergeFromBuilder(SourceBuilders.withIndent(code, 2), metadata, "template");
        }
        code.addLine("  return (%s) this;", metadata.getBuilder());
        code.addLine("}", new Object[0]);
    }

    private static void addClearMethod(SourceBuilder code, Metadata metadata) {
        if (metadata.getBuilderFactory().isPresent()) {
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Resets the state of this builder.", new Object[0]).addLine(" */", new Object[0]).addLine("public %s clear() {", metadata.getBuilder());
            List<PropertyCodeGenerator> codeGenerators = Lists.transform(metadata.getProperties(), Metadata.GET_CODE_GENERATOR);
            if (Iterables.any(codeGenerators, PropertyCodeGenerator.IS_TEMPLATE_REQUIRED_IN_CLEAR)) {
                code.add("  %s _template = ", metadata.getGeneratedBuilder());
                metadata.getBuilderFactory().get().addNewBuilder(code, metadata.getBuilder());
                code.add(";\n", new Object[0]);
            }
            for (PropertyCodeGenerator codeGenerator : codeGenerators) {
                if (codeGenerator.isTemplateRequiredInClear()) {
                    codeGenerator.addClear(SourceBuilders.withIndent(code, 2), "_template");
                    continue;
                }
                codeGenerator.addClear(SourceBuilders.withIndent(code, 2), null);
            }
            if (Iterables.any(metadata.getProperties(), IS_REQUIRED)) {
                code.addLine("  _unsetProperties.clear();", new Object[0]).addLine("  _unsetProperties.addAll(_template._unsetProperties);", metadata.getGeneratedBuilder());
            }
            code.addLine("  return (%s) this;", metadata.getBuilder()).addLine("}", new Object[0]);
        } else {
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Ensures a subsequent mergeFrom call will make a clone of its input.", new Object[0]).addLine(" *", new Object[0]).addLine(" * <p>The exact implementation of this method is not guaranteed to remain", new Object[0]).addLine(" * stable; it should always be followed directly by a mergeFrom call.", new Object[0]).addLine(" */", new Object[0]).addLine("public %s clear() {", metadata.getBuilder());
            for (Metadata.Property property : metadata.getProperties()) {
                property.getCodeGenerator().addPartialClear(SourceBuilders.withIndent(code, 2));
            }
            code.addLine("  return (%s) this;", metadata.getBuilder()).addLine("}", new Object[0]);
        }
    }

    private static void addBuildPartialMethod(SourceBuilder code, Metadata metadata) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Returns a newly-created partial {@link %s}", metadata.getType()).addLine(" * based on the contents of the {@code %s}.", metadata.getBuilder().getSimpleName()).addLine(" * State checking will not be performed.", new Object[0]);
        if (Iterables.any(metadata.getProperties(), IS_REQUIRED)) {
            code.addLine(" * Unset properties will throw an {@link %s}", UnsupportedOperationException.class).addLine(" * when accessed via the partial object.", new Object[0]);
        }
        code.addLine(" *", new Object[0]).addLine(" * <p>Partials should only ever be used in tests.", new Object[0]).addLine(" */", new Object[0]).addLine("@%s()", VisibleForTesting.class).addLine("public %s buildPartial() {", metadata.getType()).addLine("  return new %s(this);", metadata.getPartialType()).addLine("}", new Object[0]);
    }

    private static void addPropertyEnum(Metadata metadata, SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("private enum %s {", metadata.getPropertyEnum().getSimpleName());
        for (Metadata.Property property : metadata.getProperties()) {
            if (property.getCodeGenerator().getType() != PropertyCodeGenerator.Type.REQUIRED) continue;
            code.addLine("  %s(\"%s\"),", property.getAllCapsName(), property.getName());
        }
        code.addLine("  ;", new Object[0]).addLine("", new Object[0]).addLine("  private final %s name;", String.class).addLine("", new Object[0]).addLine("  private %s(%s name) {", metadata.getPropertyEnum().getSimpleName(), String.class).addLine("    this.name = name;", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @%s public %s toString() {", Override.class, String.class).addLine("    return name;", new Object[0]).addLine("  }", new Object[0]).addLine("}", new Object[0]);
    }

    private static void addValueType(SourceBuilder code, Metadata metadata) {
        code.addLine("", new Object[0]);
        if (metadata.isGwtSerializable()) {
            code.addLine("@%s(serializable = true)", GwtCompatible.class).addLine("static final class %s %s %s {", metadata.getValueType().getSimpleName(), CodeGenerator.getInheritanceKeyword(metadata.getType()), metadata.getType());
        } else {
            code.addLine("private static final class %s %s %s {", metadata.getValueType().getSimpleName(), CodeGenerator.getInheritanceKeyword(metadata.getType()), metadata.getType());
        }
        for (Metadata.Property property : metadata.getProperties()) {
            property.getCodeGenerator().addValueFieldDeclaration(SourceBuilders.withIndent(code, 2), property.getName());
        }
        code.addLine("", new Object[0]).addLine("  private %s(%s builder) {", metadata.getValueType().getSimpleName(), metadata.getGeneratedBuilder());
        for (Metadata.Property property : metadata.getProperties()) {
            property.getCodeGenerator().addFinalFieldAssignment(SourceBuilders.withIndent(code, 4), "this." + property.getName(), "builder");
        }
        code.addLine("  }", new Object[0]);
        for (Metadata.Property property : metadata.getProperties()) {
            code.addLine("", new Object[0]).addLine("  @%s", Override.class);
            for (TypeElement nullableAnnotation : property.getNullableAnnotations()) {
                code.addLine("  @%s", nullableAnnotation);
            }
            code.addLine("  public %s %s() {", property.getType(), property.getGetterName());
            code.add("    return ", new Object[0]);
            property.getCodeGenerator().addReadValueFragment(code, property.getName());
            code.add(";\n", new Object[0]);
            code.addLine("  }", new Object[0]);
        }
        switch (metadata.standardMethodUnderride(Metadata.StandardMethod.EQUALS)) {
            case ABSENT: {
                code.addLine("", new Object[0]).addLine("  @%s", Override.class).addLine("  public boolean equals(Object obj) {", new Object[0]).addLine("    if (!(obj instanceof %s)) {", metadata.getValueType()).addLine("      return false;", new Object[0]).addLine("    }", new Object[0]).addLine("    %1$s other = (%1$s) obj;", metadata.getValueType());
                if (metadata.getProperties().isEmpty()) {
                    code.addLine("    return true;", new Object[0]);
                } else if (code.getSourceLevel().javaUtilObjects().isPresent()) {
                    String prefix = "    return ";
                    for (Metadata.Property property : metadata.getProperties()) {
                        code.add(prefix, new Object[0]);
                        code.add("%1$s.equals(%2$s, other.%2$s)", code.getSourceLevel().javaUtilObjects().get(), property.getName());
                        prefix = "\n        && ";
                    }
                    code.add(";\n", new Object[0]);
                } else {
                    for (Metadata.Property property : metadata.getProperties()) {
                        switch (property.getType().getKind()) {
                            case FLOAT: 
                            case DOUBLE: {
                                code.addLine("    if (%s.doubleToLongBits(%s)", Double.class, property.getName()).addLine("        != %s.doubleToLongBits(other.%s)) {", Double.class, property.getName());
                                break;
                            }
                            default: {
                                if (property.getType().getKind().isPrimitive()) {
                                    code.addLine("    if (%1$s != other.%1$s) {", property.getName());
                                    break;
                                }
                                if (property.getCodeGenerator().getType() == PropertyCodeGenerator.Type.OPTIONAL) {
                                    code.addLine("    if (%1$s != other.%1$s", property.getName()).addLine("        && (%1$s == null || !%1$s.equals(other.%1$s))) {", property.getName());
                                    break;
                                }
                                code.addLine("    if (!%1$s.equals(other.%1$s)) {", property.getName());
                            }
                        }
                        code.addLine("      return false;", new Object[0]).addLine("    }", new Object[0]);
                    }
                    code.addLine("    return true;", new Object[0]);
                }
                code.addLine("  }", new Object[0]);
                break;
            }
            case OVERRIDEABLE: {
                code.addLine("", new Object[0]).addLine("  @%s", Override.class).addLine("  public boolean equals(Object obj) {", new Object[0]).addLine("    return (!(obj instanceof %s) && super.equals(obj));", metadata.getPartialType()).addLine("  }", new Object[0]);
                break;
            }
        }
        if (metadata.standardMethodUnderride(Metadata.StandardMethod.HASH_CODE) == Metadata.UnderrideLevel.ABSENT) {
            String properties = Joiner.on(", ").join(CodeGenerator.getNames(metadata.getProperties()));
            code.addLine("", new Object[0]).addLine("  @%s", Override.class).addLine("  public int hashCode() {", new Object[0]);
            if (code.getSourceLevel().javaUtilObjects().isPresent()) {
                code.addLine("    return %s.hash(%s);", code.getSourceLevel().javaUtilObjects().get(), properties);
            } else {
                code.addLine("    return %s.hashCode(new Object[] { %s });", Arrays.class, properties);
            }
            code.addLine("  }", new Object[0]);
        }
        if (metadata.standardMethodUnderride(Metadata.StandardMethod.TO_STRING) == Metadata.UnderrideLevel.ABSENT) {
            code.addLine("", new Object[0]).addLine("  @%s", Override.class).addLine("  public %s toString() {", String.class).add("    return \"%s{", metadata.getType().getSimpleName());
            switch (metadata.getProperties().size()) {
                case 0: {
                    code.add("}\";\n", new Object[0]);
                    break;
                }
                case 1: {
                    Metadata.Property property = Iterables.getOnlyElement(metadata.getProperties());
                    if (property.getCodeGenerator().getType() == PropertyCodeGenerator.Type.OPTIONAL) {
                        code.add("\" + (%1$s != null ? \"%1$s=\" + %1$s : \"\") + \"}\";\n", property.getName());
                        break;
                    }
                    code.add("%1$s=\" + %1$s + \"}\";\n", property.getName());
                    break;
                }
                default: {
                    Metadata.Property lastProperty;
                    if (Iterables.any(metadata.getProperties(), IS_OPTIONAL)) {
                        code.add("\"\n", new Object[0]).add("        + COMMA_JOINER.join(\n", new Object[0]);
                        lastProperty = Iterables.getLast(metadata.getProperties());
                        for (Metadata.Property property : metadata.getProperties()) {
                            code.add("            ", new Object[0]);
                            if (property.getCodeGenerator().getType() == PropertyCodeGenerator.Type.OPTIONAL) {
                                code.add("(%s != null ? ", property.getName());
                            }
                            code.add("\"%1$s=\" + %1$s", property.getName());
                            if (property.getCodeGenerator().getType() == PropertyCodeGenerator.Type.OPTIONAL) {
                                code.add(" : null)", new Object[0]);
                            }
                            if (property != lastProperty) {
                                code.add(",\n", new Object[0]);
                                continue;
                            }
                            code.add(")\n", new Object[0]);
                        }
                        code.addLine("        + \"}\";", new Object[0]);
                        break;
                    }
                    code.add("\"\n", new Object[0]);
                    lastProperty = Iterables.getLast(metadata.getProperties());
                    for (Metadata.Property property : metadata.getProperties()) {
                        code.add("        + \"%1$s=\" + %1$s", property.getName());
                        if (property != lastProperty) {
                            code.add(" + \", \"\n", new Object[0]);
                            continue;
                        }
                        code.add(" + \"}\";\n", new Object[0]);
                    }
                }
            }
            code.addLine("  }", new Object[0]);
        }
        code.addLine("}", new Object[0]);
    }

    private static void addCustomValueSerializer(SourceBuilder code, Metadata metadata) {
        code.addLine("", new Object[0]).addLine("  @%s", GwtCompatible.class).addLine("  public static class %s_CustomFieldSerializer", metadata.getValueType().getSimpleName()).addLine("      extends %s<%s> {", CUSTOM_FIELD_SERIALIZER, metadata.getValueType()).addLine("", new Object[0]).addLine("    @%s", Override.class).addLine("    public void deserializeInstance(%s reader, %s instance) { }", SERIALIZATION_STREAM_READER, metadata.getValueType()).addLine("", new Object[0]).addLine("    @%s", Override.class).addLine("    public boolean hasCustomInstantiateInstance() {", new Object[0]).addLine("      return true;", new Object[0]).addLine("    }", new Object[0]).addLine("", new Object[0]).addLine("    @%s", Override.class).addLine("    public %s instantiateInstance(%s reader)", metadata.getValueType(), SERIALIZATION_STREAM_READER).addLine("        throws %s {", SERIALIZATION_EXCEPTION).addLine("      %1$s builder = new %1$s();", metadata.getBuilder());
        for (Metadata.Property property : metadata.getProperties()) {
            if (property.getType().getKind().isPrimitive()) {
                code.addLine("        %s %s = reader.read%s();", property.getType(), property.getName(), CodeGenerator.withInitialCapital(property.getType()));
                property.getCodeGenerator().addSetFromResult(SourceBuilders.withIndent(code, 6), "builder", property.getName());
                continue;
            }
            if (String.class.getName().equals(property.getType().toString())) {
                code.addLine("        %s %s = reader.readString();", property.getType(), property.getName());
                property.getCodeGenerator().addSetFromResult(SourceBuilders.withIndent(code, 6), "builder", property.getName());
                continue;
            }
            code.addLine("      try {", new Object[0]);
            if (!property.isFullyCheckedCast()) {
                code.addLine("        @SuppressWarnings(\"unchecked\")", new Object[0]);
            }
            code.addLine("        %1$s %2$s = (%1$s) reader.readObject();", property.getType(), property.getName());
            property.getCodeGenerator().addSetFromResult(SourceBuilders.withIndent(code, 8), "builder", property.getName());
            code.addLine("      } catch (%s e) {", ClassCastException.class).addLine("        throw new %s(", SERIALIZATION_EXCEPTION).addLine("            \"Wrong type for property '%s'\", e);", property.getName()).addLine("      }", new Object[0]);
        }
        code.addLine("      return (%s) builder.build();", metadata.getValueType()).addLine("    }", new Object[0]).addLine("", new Object[0]).addLine("    @%s", Override.class).addLine("    public void serializeInstance(%s writer, %s instance)", SERIALIZATION_STREAM_WRITER, metadata.getValueType()).addLine("        throws %s {", SERIALIZATION_EXCEPTION);
        for (Metadata.Property property : metadata.getProperties()) {
            if (property.getType().getKind().isPrimitive()) {
                code.add("      writer.write%s(", CodeGenerator.withInitialCapital(property.getType()), property.getName());
            } else if (String.class.getName().equals(property.getType().toString())) {
                code.add("      writer.writeString(", property.getName());
            } else {
                code.add("      writer.writeObject(", property.getName());
            }
            property.getCodeGenerator().addReadValueFragment(code, "instance." + property.getName());
            code.add(");\n", new Object[0]);
        }
        code.addLine("    }", new Object[0]).addLine("", new Object[0]).addLine("    private static final Value_CustomFieldSerializer INSTANCE = new Value_CustomFieldSerializer();", new Object[0]).addLine("", new Object[0]).addLine("    public static void deserialize(%s reader, %s instance) {", SERIALIZATION_STREAM_READER, metadata.getValueType()).addLine("      INSTANCE.deserializeInstance(reader, instance);", new Object[0]).addLine("    }", new Object[0]).addLine("", new Object[0]).addLine("    public static %s instantiate(%s reader)", metadata.getValueType(), SERIALIZATION_STREAM_READER).addLine("        throws %s {", SERIALIZATION_EXCEPTION).addLine("      return INSTANCE.instantiateInstance(reader);", new Object[0]).addLine("    }", new Object[0]).addLine("", new Object[0]).addLine("    public static void serialize(%s writer, %s instance)", SERIALIZATION_STREAM_WRITER, metadata.getValueType()).addLine("        throws %s {", SERIALIZATION_EXCEPTION).addLine("      INSTANCE.serializeInstance(writer, instance);", new Object[0]).addLine("    }", new Object[0]).addLine("  }", new Object[0]);
    }

    private static void addGwtWhitelistType(SourceBuilder code, Metadata metadata) {
        code.addLine("", new Object[0]).addLine("  /** This class exists solely to ensure GWT whitelists all required types. */", new Object[0]).addLine("  @%s(serializable = true)", GwtCompatible.class).addLine("  static final class GwtWhitelist %s %s {", CodeGenerator.getInheritanceKeyword(metadata.getType()), metadata.getType()).addLine("", new Object[0]);
        for (Metadata.Property property : metadata.getProperties()) {
            code.addLine("    %s %s;", property.getType(), property.getName());
        }
        code.addLine("", new Object[0]).addLine("    private GwtWhitelist() {", new Object[0]).addLine("      throw new %s();", UnsupportedOperationException.class).addLine("    }", new Object[0]);
        for (Metadata.Property property : metadata.getProperties()) {
            code.addLine("", new Object[0]).addLine("    @%s", Override.class).addLine("    public %s %s() {", property.getType(), property.getGetterName());
            code.addLine("      throw new %s();", UnsupportedOperationException.class).addLine("    }", new Object[0]);
        }
        code.addLine("  }", new Object[0]);
    }

    private static void addPartialType(SourceBuilder code, Metadata metadata) {
        boolean hasRequiredProperties = Iterables.any(metadata.getProperties(), IS_REQUIRED);
        code.addLine("", new Object[0]).addLine("private static final class %s %s %s {", metadata.getPartialType().getSimpleName(), CodeGenerator.getInheritanceKeyword(metadata.getType()), metadata.getType());
        for (Metadata.Property property : metadata.getProperties()) {
            property.getCodeGenerator().addValueFieldDeclaration(SourceBuilders.withIndent(code, 2), property.getName());
        }
        if (hasRequiredProperties) {
            code.addLine("  private final %s<%s> _unsetProperties;", EnumSet.class, metadata.getPropertyEnum());
        }
        code.addLine("", new Object[0]).addLine("  %s(%s builder) {", metadata.getPartialType().getSimpleName(), metadata.getGeneratedBuilder());
        for (Metadata.Property property : metadata.getProperties()) {
            property.getCodeGenerator().addPartialFieldAssignment(SourceBuilders.withIndent(code, 4), "this." + property.getName(), "builder");
        }
        if (hasRequiredProperties) {
            code.addLine("    this._unsetProperties = builder._unsetProperties.clone();", new Object[0]);
        }
        code.addLine("  }", new Object[0]);
        for (Metadata.Property property : metadata.getProperties()) {
            code.addLine("", new Object[0]).addLine("  @%s", Override.class);
            for (TypeElement nullableAnnotation : property.getNullableAnnotations()) {
                code.addLine("  @%s", nullableAnnotation);
            }
            code.addLine("  public %s %s() {", property.getType(), property.getGetterName());
            if (property.getCodeGenerator().getType() == PropertyCodeGenerator.Type.REQUIRED) {
                code.addLine("    if (_unsetProperties.contains(%s.%s)) {", metadata.getPropertyEnum(), property.getAllCapsName()).addLine("      throw new %s(\"%s not set\");", UnsupportedOperationException.class, property.getName()).addLine("    }", new Object[0]);
            }
            code.add("    return ", new Object[0]);
            property.getCodeGenerator().addReadValueFragment(code, property.getName());
            code.add(";\n", new Object[0]);
            code.addLine("  }", new Object[0]);
        }
        if (metadata.standardMethodUnderride(Metadata.StandardMethod.EQUALS) != Metadata.UnderrideLevel.FINAL) {
            code.addLine("", new Object[0]).addLine("  @%s", Override.class).addLine("  public boolean equals(Object obj) {", new Object[0]).addLine("    if (!(obj instanceof %s)) {", metadata.getPartialType()).addLine("      return false;", new Object[0]).addLine("    }", new Object[0]).addLine("    %1$s other = (%1$s) obj;", metadata.getPartialType());
            if (metadata.getProperties().isEmpty()) {
                code.addLine("    return true;", new Object[0]);
            } else if (code.getSourceLevel().javaUtilObjects().isPresent()) {
                String prefix = "    return ";
                for (Metadata.Property property : metadata.getProperties()) {
                    code.add(prefix, new Object[0]);
                    code.add("%1$s.equals(%2$s, other.%2$s)", code.getSourceLevel().javaUtilObjects().get(), property.getName());
                    prefix = "\n        && ";
                }
                if (hasRequiredProperties) {
                    code.add(prefix, new Object[0]);
                    code.add("%1$s.equals(_unsetProperties, other._unsetProperties)", code.getSourceLevel().javaUtilObjects().get());
                }
                code.add(";\n", new Object[0]);
            } else {
                for (Metadata.Property property : metadata.getProperties()) {
                    switch (property.getType().getKind()) {
                        case FLOAT: 
                        case DOUBLE: {
                            code.addLine("    if (%s.doubleToLongBits(%s)", Double.class, property.getName()).addLine("        != %s.doubleToLongBits(other.%s)) {", Double.class, property.getName());
                            break;
                        }
                        default: {
                            if (property.getType().getKind().isPrimitive()) {
                                code.addLine("    if (%1$s != other.%1$s) {", property.getName());
                                break;
                            }
                            if (property.getCodeGenerator().getType() == PropertyCodeGenerator.Type.HAS_DEFAULT) {
                                code.addLine("    if (!%1$s.equals(other.%1$s)) {", property.getName());
                                break;
                            }
                            code.addLine("    if (%1$s != other.%1$s", property.getName()).addLine("        && (%1$s == null || !%1$s.equals(other.%1$s))) {", property.getName());
                        }
                    }
                    code.addLine("      return false;", new Object[0]).addLine("    }", new Object[0]);
                }
                if (hasRequiredProperties) {
                    code.addLine("    return _unsetProperties.equals(other._unsetProperties);", new Object[0]);
                } else {
                    code.addLine("    return true;", new Object[0]);
                }
            }
            code.addLine("  }", new Object[0]);
        }
        if (metadata.standardMethodUnderride(Metadata.StandardMethod.HASH_CODE) != Metadata.UnderrideLevel.FINAL) {
            code.addLine("", new Object[0]).addLine("  @%s", Override.class).addLine("  public int hashCode() {", new Object[0]);
            ImmutableCollection namesList = CodeGenerator.getNames(metadata.getProperties());
            if (hasRequiredProperties) {
                namesList = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll((Iterable)namesList)).add("_unsetProperties")).build();
            }
            String properties = Joiner.on(", ").join(namesList);
            if (code.getSourceLevel().javaUtilObjects().isPresent()) {
                code.addLine("    return %s.hash(%s);", code.getSourceLevel().javaUtilObjects().get(), properties);
            } else {
                code.addLine("    return %s.hashCode(new Object[] { %s });", Arrays.class, properties);
            }
            code.addLine("  }", new Object[0]);
        }
        if (metadata.standardMethodUnderride(Metadata.StandardMethod.TO_STRING) != Metadata.UnderrideLevel.FINAL) {
            code.addLine("", new Object[0]).addLine("  @%s", Override.class).addLine("  public %s toString() {", String.class);
            code.add("    return \"partial %s{", metadata.getType().getSimpleName());
            switch (metadata.getProperties().size()) {
                case 0: {
                    code.add("}\";\n", new Object[0]);
                    break;
                }
                case 1: {
                    Metadata.Property property = Iterables.getOnlyElement(metadata.getProperties());
                    switch (property.getCodeGenerator().getType()) {
                        case HAS_DEFAULT: {
                            code.add("%1$s=\" + %1$s + \"}\";\n", property.getName());
                            break;
                        }
                        case OPTIONAL: {
                            code.add("\"\n", new Object[0]).addLine("        + (%1$s != null ? \"%1$s=\" + %1$s : \"\")", property.getName()).addLine("        + \"}\";", new Object[0]);
                            break;
                        }
                        case REQUIRED: {
                            code.add("\"\n", new Object[0]).addLine("        + (!_unsetProperties.contains(%s.%s)", metadata.getPropertyEnum(), property.getAllCapsName()).addLine("            ? \"%1$s=\" + %1$s : \"\")", property.getName()).addLine("        + \"}\";", new Object[0]);
                        }
                    }
                    break;
                }
                default: {
                    code.add("\"\n", new Object[0]).add("        + COMMA_JOINER.join(\n", new Object[0]);
                    Metadata.Property lastProperty = Iterables.getLast(metadata.getProperties());
                    for (Metadata.Property property : metadata.getProperties()) {
                        code.add("            ", new Object[0]);
                        switch (property.getCodeGenerator().getType()) {
                            case HAS_DEFAULT: {
                                code.add("\"%1$s=\" + %1$s", property.getName());
                                break;
                            }
                            case OPTIONAL: {
                                code.add("(%1$s != null ? \"%1$s=\" + %1$s : null)", property.getName());
                                break;
                            }
                            case REQUIRED: {
                                code.add("(!_unsetProperties.contains(%s.%s)\n", metadata.getPropertyEnum(), property.getAllCapsName()).add("                ? \"%1$s=\" + %1$s : null)", property.getName());
                            }
                        }
                        if (property != lastProperty) {
                            code.add(",\n", new Object[0]);
                            continue;
                        }
                        code.add(")\n", new Object[0]);
                    }
                    code.addLine("        + \"}\";", new Object[0]);
                    break;
                }
            }
            code.addLine("  }", new Object[0]);
        }
        code.addLine("}", new Object[0]);
    }

    private void writeStubSource(SourceBuilder code, Metadata metadata) {
        code.addLine("/**", new Object[0]).addLine(" * Placeholder. Create {@code %s.Builder} and subclass this type.", metadata.getType()).addLine(" */", new Object[0]).addLine("@%s(\"%s\")", Generated.class, this.getClass().getName()).addLine("abstract class %s {}", metadata.getGeneratedBuilder().getSimpleName());
    }

    private static String getInheritanceKeyword(TypeElement type) {
        if (type.getKind().isInterface()) {
            return "implements";
        }
        return "extends";
    }

    private static String withInitialCapital(Object obj) {
        String s = obj.toString();
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    private static ImmutableList<String> getNames(Iterable<Metadata.Property> properties) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (Metadata.Property property : properties) {
            result.add(property.getName());
        }
        return result.build();
    }
}

