/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor;

import javax.lang.model.element.TypeElement;
import org.inferred.freebuilder.processor.Metadata;
import org.inferred.freebuilder.processor.PropertyCodeGenerator;
import org.inferred.freebuilder.processor.util.SourceBuilder;
import org.inferred.freebuilder.shaded.com.google.common.annotations.VisibleForTesting;
import org.inferred.freebuilder.shaded.com.google.common.base.Optional;
import org.inferred.freebuilder.shaded.com.google.common.base.Preconditions;

public class DefaultPropertyFactory
implements PropertyCodeGenerator.Factory {
    private static final String SET_PREFIX = "set";

    @Override
    public Optional<? extends PropertyCodeGenerator> create(PropertyCodeGenerator.Config config) {
        String setterName = SET_PREFIX + config.getProperty().getCapitalizedName();
        boolean hasDefault = !config.getProperty().getNullableAnnotations().isEmpty() || config.getMethodsInvokedInBuilderConstructor().contains(setterName);
        return Optional.of(new CodeGenerator(config.getProperty(), setterName, hasDefault));
    }

    @VisibleForTesting
    static class CodeGenerator
    extends PropertyCodeGenerator {
        final String setterName;
        final boolean hasDefault;
        final boolean isPrimitive;
        final boolean isNullable;

        CodeGenerator(Metadata.Property property, String setterName, boolean hasDefault) {
            super(property);
            this.setterName = setterName;
            this.hasDefault = hasDefault;
            this.isPrimitive = property.getType().getKind().isPrimitive();
            this.isNullable = !property.getNullableAnnotations().isEmpty();
        }

        @Override
        public PropertyCodeGenerator.Type getType() {
            return this.isNullable ? PropertyCodeGenerator.Type.OPTIONAL : (this.hasDefault ? PropertyCodeGenerator.Type.HAS_DEFAULT : PropertyCodeGenerator.Type.REQUIRED);
        }

        @Override
        public void addBuilderFieldDeclaration(SourceBuilder code) {
            code.add("", new Object[0]);
            for (TypeElement nullableAnnotation : this.property.getNullableAnnotations()) {
                code.add("@%s ", nullableAnnotation);
            }
            code.add("private %s %s", this.property.getType(), this.property.getName());
            if (this.isNullable) {
                code.add(" = null", new Object[0]);
            }
            code.add(";\n", new Object[0]);
        }

        @Override
        public void addBuilderFieldAccessors(SourceBuilder code, Metadata metadata) {
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Sets the value to be returned by {@link %s#%s()}.", metadata.getType(), this.property.getGetterName()).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", metadata.getBuilder().getSimpleName());
            if (!this.isNullable && !this.isPrimitive) {
                code.addLine(" * @throws NullPointerException if {@code %s} is null", this.property.getName());
            }
            code.addLine(" */", new Object[0]);
            code.add("public %s %s(", metadata.getBuilder(), this.setterName);
            for (TypeElement nullableAnnotation : this.property.getNullableAnnotations()) {
                code.add("@%s ", nullableAnnotation);
            }
            code.add("%s %s) {\n", this.property.getType(), this.property.getName());
            if (this.isNullable || this.isPrimitive) {
                code.addLine("  this.%1$s = %1$s;", this.property.getName());
            } else {
                code.addLine("  this.%1$s = %2$s.checkNotNull(%1$s);", this.property.getName(), Preconditions.class);
            }
            if (!this.hasDefault) {
                code.addLine("  _unsetProperties.remove(%s.%s);", metadata.getPropertyEnum(), this.property.getAllCapsName());
            }
            if (metadata.getBuilder() == metadata.getGeneratedBuilder()) {
                code.addLine("  return this;", new Object[0]);
            } else {
                code.addLine("  return (%s) this;", metadata.getBuilder());
            }
            code.addLine("}", new Object[0]);
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Returns the value that will be returned by {@link %s#%s()}.", metadata.getType(), this.property.getGetterName());
            if (!this.hasDefault) {
                code.addLine(" *", new Object[0]).addLine(" * @throws IllegalStateException if the field has not been set", new Object[0]);
            }
            code.addLine(" */", new Object[0]);
            for (TypeElement nullableAnnotation : this.property.getNullableAnnotations()) {
                code.addLine("@%s", nullableAnnotation);
            }
            code.addLine("public %s %s() {", this.property.getType(), this.property.getGetterName());
            if (!this.hasDefault) {
                code.addLine("  %s.checkState(", Preconditions.class).addLine("      !_unsetProperties.contains(%s.%s),", metadata.getPropertyEnum(), this.property.getAllCapsName()).addLine("      \"%s not set\");", this.property.getName());
            }
            code.addLine("  return %s;", this.property.getName()).addLine("}", new Object[0]);
        }

        @Override
        public void addValueFieldDeclaration(SourceBuilder code, String finalField) {
            for (TypeElement nullableAnnotation : this.property.getNullableAnnotations()) {
                code.add("@%s ", nullableAnnotation);
            }
            code.add("private final %s %s;\n", this.property.getType(), finalField);
        }

        @Override
        public void addFinalFieldAssignment(SourceBuilder code, String finalField, String builder) {
            code.addLine("%s = %s.%s;", finalField, builder, this.property.getName());
        }

        @Override
        public void addMergeFromValue(SourceBuilder code, String value) {
            code.addLine("%s(%s.%s());", this.setterName, value, this.property.getGetterName());
        }

        @Override
        public void addMergeFromBuilder(SourceBuilder code, Metadata metadata, String builder) {
            code.addLine("%s(%s.%s());", this.setterName, builder, this.property.getGetterName());
        }

        @Override
        public void addSetFromResult(SourceBuilder code, String builder, String variable) {
            code.addLine("%s.%s(%s);", builder, this.setterName, variable);
        }

        @Override
        public boolean isTemplateRequiredInClear() {
            return true;
        }

        @Override
        public void addClear(SourceBuilder code, String template) {
            code.addLine("%1$s = %2$s.%1$s;", this.property.getName(), template);
        }

        @Override
        public void addPartialClear(SourceBuilder code) {
            if (this.isNullable) {
                code.addLine("%s = null;", this.property.getName());
            }
        }
    }
}

