/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.inferred.freebuilder.processor.Metadata;
import org.inferred.freebuilder.processor.PropertyCodeGenerator;
import org.inferred.freebuilder.processor.Util;
import org.inferred.freebuilder.processor.util.SourceBuilder;
import org.inferred.freebuilder.shaded.com.google.common.annotations.VisibleForTesting;
import org.inferred.freebuilder.shaded.com.google.common.base.Optional;
import org.inferred.freebuilder.shaded.com.google.common.base.Preconditions;
import org.inferred.freebuilder.shaded.com.google.common.collect.ImmutableList;

public class ListPropertyFactory
implements PropertyCodeGenerator.Factory {
    private static final String ADD_PREFIX = "add";
    private static final String ADD_ALL_PREFIX = "addAll";
    private static final String CLEAR_PREFIX = "clear";
    private static final String GET_PREFIX = "get";

    @Override
    public Optional<? extends PropertyCodeGenerator> create(PropertyCodeGenerator.Config config) {
        if (!config.getProperty().getNullableAnnotations().isEmpty()) {
            return Optional.absent();
        }
        if (config.getProperty().getType().getKind() == TypeKind.DECLARED) {
            DeclaredType type = (DeclaredType)config.getProperty().getType();
            if (Util.erasesToAnyOf(type, Collection.class, List.class, ImmutableList.class)) {
                Optional<TypeMirror> unboxedType;
                TypeMirror elementType = Util.upperBound(config.getElements(), type.getTypeArguments().get(0));
                try {
                    unboxedType = Optional.of(config.getTypes().unboxedType(elementType));
                }
                catch (IllegalArgumentException e) {
                    unboxedType = Optional.absent();
                }
                return Optional.of(new CodeGenerator(config.getProperty(), elementType, unboxedType));
            }
        }
        return Optional.absent();
    }

    @VisibleForTesting
    static class CodeGenerator
    extends PropertyCodeGenerator {
        private final TypeMirror elementType;
        private final Optional<TypeMirror> unboxedType;

        @VisibleForTesting
        CodeGenerator(Metadata.Property property, TypeMirror elementType, Optional<TypeMirror> unboxedType) {
            super(property);
            this.elementType = elementType;
            this.unboxedType = unboxedType;
        }

        @Override
        public void addBuilderFieldDeclaration(SourceBuilder code) {
            code.addLine("private final %1$s<%2$s> %3$s = new %1$s<%4$s>();", ArrayList.class, this.elementType, this.property.getName(), code.getSourceLevel().supportsDiamondOperator() ? "" : this.elementType);
        }

        @Override
        public void addBuilderFieldAccessors(SourceBuilder code, Metadata metadata) {
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Adds {@code element} to the list to be returned from {@link %s#%s()}.", metadata.getType(), this.property.getGetterName()).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", metadata.getBuilder().getSimpleName());
            if (!this.unboxedType.isPresent()) {
                code.addLine(" * @throws NullPointerException if {@code element} is null", new Object[0]);
            }
            code.addLine(" */", new Object[0]).addLine("public %s %s%s(%s element) {", metadata.getBuilder(), ListPropertyFactory.ADD_PREFIX, this.property.getCapitalizedName(), this.unboxedType.or(this.elementType));
            if (this.unboxedType.isPresent()) {
                code.addLine("  this.%s.add(element);", this.property.getName());
            } else {
                code.addLine("  this.%s.add(%s.checkNotNull(element));", this.property.getName(), Preconditions.class);
            }
            code.addLine("  return (%s) this;", metadata.getBuilder()).addLine("}", new Object[0]);
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Adds each element of {@code elements} to the list to be returned from", new Object[0]).addLine(" * {@link %s#%s()}.", metadata.getType(), this.property.getGetterName()).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", metadata.getBuilder().getSimpleName());
            if (!this.unboxedType.isPresent()) {
                code.addLine(" * @throws NullPointerException if {@code elements} is null or contains a", new Object[0]).addLine(" *     null element", new Object[0]);
            }
            code.addLine(" */", new Object[0]).addLine("public %s %s%s(%s... elements) {", metadata.getBuilder(), ListPropertyFactory.ADD_PREFIX, this.property.getCapitalizedName(), this.unboxedType.or(this.elementType)).addLine("  %1$s.ensureCapacity(%1$s.size() + elements.length);", this.property.getName()).addLine("  for (%s element : elements) {", this.unboxedType.or(this.elementType)).addLine("    %s%s(element);", ListPropertyFactory.ADD_PREFIX, this.property.getCapitalizedName()).addLine("  }", new Object[0]).addLine("  return (%s) this;", metadata.getBuilder()).addLine("}", new Object[0]);
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Adds each element of {@code elements} to the list to be returned from", new Object[0]).addLine(" * {@link %s#%s()}.", metadata.getType(), this.property.getGetterName()).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", metadata.getBuilder().getSimpleName()).addLine(" * @throws NullPointerException if {@code elements} is null or contains a", new Object[0]).addLine(" *     null element", new Object[0]).addLine(" */", new Object[0]).addLine("public %s %s%s(%s<? extends %s> elements) {", metadata.getBuilder(), ListPropertyFactory.ADD_ALL_PREFIX, this.property.getCapitalizedName(), Iterable.class, this.elementType).addLine("  if (elements instanceof %s) {", Collection.class).addLine("    %1$s.ensureCapacity(%1$s.size() + ((%2$s<?>) elements).size());", this.property.getName(), Collection.class).addLine("  }", new Object[0]).addLine("  for (%s element : elements) {", this.unboxedType.or(this.elementType)).addLine("    %s%s(element);", ListPropertyFactory.ADD_PREFIX, this.property.getCapitalizedName()).addLine("  }", new Object[0]).addLine("  return (%s) this;", metadata.getBuilder()).addLine("}", new Object[0]);
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Clears the list to be returned from {@link %s#%s()}.", metadata.getType(), this.property.getGetterName()).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", metadata.getBuilder().getSimpleName()).addLine(" */", new Object[0]).addLine("public %s %s%s() {", metadata.getBuilder(), ListPropertyFactory.CLEAR_PREFIX, this.property.getCapitalizedName()).addLine("  this.%s.clear();", this.property.getName()).addLine("  return (%s) this;", metadata.getBuilder()).addLine("}", new Object[0]);
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Returns an unmodifiable view of the list that will be returned by", new Object[0]).addLine(" * {@link %s#%s()}.", metadata.getType(), this.property.getGetterName()).addLine(" * Changes to this builder will be reflected in the view.", new Object[0]).addLine(" */", new Object[0]).addLine("public %s<%s> %s%s() {", List.class, this.elementType, ListPropertyFactory.GET_PREFIX, this.property.getCapitalizedName()).addLine("  return %s.unmodifiableList(%s);", Collections.class, this.property.getName()).addLine("}", new Object[0]);
        }

        @Override
        public void addFinalFieldAssignment(SourceBuilder code, String finalField, String builder) {
            code.addLine("%s = %s.copyOf(%s.%s);", finalField, ImmutableList.class, builder, this.property.getName());
        }

        @Override
        public void addMergeFromValue(SourceBuilder code, String value) {
            code.addLine("%s%s(%s.%s());", ListPropertyFactory.ADD_ALL_PREFIX, this.property.getCapitalizedName(), value, this.property.getGetterName());
        }

        @Override
        public void addMergeFromBuilder(SourceBuilder code, Metadata metadata, String builder) {
            code.addLine("%s%s(((%s) %s).%s);", ListPropertyFactory.ADD_ALL_PREFIX, this.property.getCapitalizedName(), metadata.getGeneratedBuilder(), builder, this.property.getName());
        }

        @Override
        public void addSetFromResult(SourceBuilder code, String builder, String variable) {
            code.addLine("%s.%s%s(%s);", builder, ListPropertyFactory.ADD_ALL_PREFIX, this.property.getCapitalizedName(), variable);
        }

        @Override
        public boolean isTemplateRequiredInClear() {
            return false;
        }

        @Override
        public void addClear(SourceBuilder code, String template) {
            code.addLine("%s.clear();", this.property.getName());
        }

        @Override
        public void addPartialClear(SourceBuilder code) {
            code.addLine("%s.clear();", this.property.getName());
        }
    }
}

